/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import com.google.bigtable.repackaged.io.grpc.netty.AbstractNettyHandler;
import com.google.bigtable.repackaged.io.grpc.netty.CancelServerStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServerStream;
import com.google.bigtable.repackaged.io.grpc.netty.RequestMessagesCommand;
import com.google.bigtable.repackaged.io.grpc.netty.SendGrpcFrameCommand;
import com.google.bigtable.repackaged.io.grpc.netty.SendResponseHeadersCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.grpc.netty.WriteQueue;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.netty.channel.ChannelPromise;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2Connection;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Connection;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Error;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Exception;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameAdapter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameLogger;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameReader;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameWriter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2InboundFrameLogger;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Settings;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Stream;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.google.bigtable.repackaged.io.netty.handler.logging.LogLevel;
import com.google.bigtable.repackaged.io.netty.util.ReferenceCountUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServerHandler
extends AbstractNettyHandler {
    private static Logger logger = Logger.getLogger(NettyServerHandler.class.getName());
    private static final Status GOAWAY_STATUS = Status.UNAVAILABLE;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final Http2Connection.PropertyKey streamKey;
    private final ServerTransportListener transportListener;
    private final int maxMessageSize;
    private Throwable connectionError;
    private boolean teWarningLogged;
    private WriteQueue serverWriteQueue;

    static NettyServerHandler newHandler(ServerTransportListener transportListener, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, int maxStreams, int flowControlWindow, int maxHeaderListSize, int maxMessageSize) {
        Preconditions.checkArgument(maxHeaderListSize > 0, "maxHeaderListSize must be positive");
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, NettyServerHandler.class);
        DefaultHttp2HeadersDecoder headersDecoder = new DefaultHttp2HeadersDecoder(maxHeaderListSize, 4096);
        Http2InboundFrameLogger frameReader = new Http2InboundFrameLogger(new DefaultHttp2FrameReader(headersDecoder), frameLogger);
        Http2OutboundFrameLogger frameWriter = new Http2OutboundFrameLogger(new DefaultHttp2FrameWriter(), frameLogger);
        return NettyServerHandler.newHandler(frameReader, frameWriter, transportListener, decompressorRegistry, compressorRegistry, maxStreams, flowControlWindow, maxMessageSize);
    }

    @VisibleForTesting
    static NettyServerHandler newHandler(Http2FrameReader frameReader, Http2FrameWriter frameWriter, ServerTransportListener transportListener, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, int maxStreams, int flowControlWindow, int maxMessageSize) {
        Preconditions.checkArgument(maxStreams > 0, "maxStreams must be positive");
        Preconditions.checkArgument(flowControlWindow > 0, "flowControlWindow must be positive");
        Preconditions.checkArgument(maxMessageSize > 0, "maxMessageSize must be positive");
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        connection.local().flowController(new DefaultHttp2LocalFlowController(connection, 0.5f, true));
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(connection, frameWriter);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(connection, encoder, frameReader);
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize(flowControlWindow);
        settings.maxConcurrentStreams(maxStreams);
        return new NettyServerHandler(transportListener, decoder, encoder, settings, decompressorRegistry, compressorRegistry, maxMessageSize);
    }

    private NettyServerHandler(ServerTransportListener transportListener, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings settings, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, int maxMessageSize) {
        super(decoder, encoder, settings);
        Preconditions.checkArgument(maxMessageSize >= 0, "maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        this.decompressorRegistry = Preconditions.checkNotNull(decompressorRegistry, "decompressorRegistry");
        this.compressorRegistry = Preconditions.checkNotNull(compressorRegistry, "compressorRegistry");
        this.streamKey = encoder.connection().newKey();
        this.transportListener = Preconditions.checkNotNull(transportListener, "transportListener");
        this.decoder().frameListener(new FrameListener());
    }

    @Nullable
    Throwable connectionError() {
        return this.connectionError;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.serverWriteQueue = new WriteQueue(ctx.channel());
        super.handlerAdded(ctx);
    }

    private void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers) throws Http2Exception {
        if (!this.teWarningLogged && !Utils.TE_TRAILERS.equals(headers.get(Utils.TE_HEADER))) {
            logger.warning(String.format("Expected header TE: %s, but %s is received. This means some intermediate proxy may not support trailers", Utils.TE_TRAILERS, headers.get(Utils.TE_HEADER)));
            this.teWarningLogged = true;
        }
        try {
            this.verifyContentType(streamId, headers);
            String method = this.determineMethod(streamId, headers);
            Http2Stream http2Stream = this.requireHttp2Stream(streamId);
            NettyServerStream stream = new NettyServerStream(ctx.channel(), http2Stream, this, this.maxMessageSize);
            stream.setDecompressionRegistry(this.decompressorRegistry);
            stream.setCompressionRegistry(this.compressorRegistry);
            Metadata metadata = Utils.convertHeaders(headers);
            stream.inboundHeadersReceived(metadata);
            ServerStreamListener listener = this.transportListener.streamCreated(stream, method, metadata);
            stream.setListener(listener);
            http2Stream.setProperty(this.streamKey, stream);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onHeadersRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onDataRead(int streamId, ByteBuf data, boolean endOfStream) throws Http2Exception {
        try {
            NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.inboundDataReceived(data, endOfStream);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onDataRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onRstStreamRead(int streamId) throws Http2Exception {
        try {
            NettyServerStream stream = this.serverStream(this.connection().stream(streamId));
            if (stream != null) {
                stream.abortStream(Status.CANCELLED, false);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onRstStreamRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.WARNING, "Connection Error", cause);
        this.connectionError = cause;
        super.onConnectionError(ctx, cause, http2Ex);
    }

    @Override
    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        logger.log(Level.WARNING, "Stream Error", cause);
        NettyServerStream serverStream = this.serverStream(this.connection().stream(Http2Exception.streamId(http2Ex)));
        if (serverStream != null) {
            serverStream.abortStream(Utils.statusFromThrowable(cause), true);
        } else {
            super.onStreamError(ctx, cause, http2Ex);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream stream) throws Http2Exception {
                    NettyServerStream serverStream = NettyServerHandler.this.serverStream(stream);
                    if (serverStream != null) {
                        serverStream.abortStream(GOAWAY_STATUS, false);
                    }
                    return true;
                }
            });
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    WriteQueue getWriteQueue() {
        return this.serverWriteQueue;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Http2Exception {
        if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)msg, promise);
        } else if (msg instanceof SendResponseHeadersCommand) {
            this.sendResponseHeaders(ctx, (SendResponseHeadersCommand)msg, promise);
        } else if (msg instanceof RequestMessagesCommand) {
            ((RequestMessagesCommand)msg).requestMessages();
        } else if (msg instanceof CancelServerStreamCommand) {
            this.cancelStream(ctx, (CancelServerStreamCommand)msg, promise);
        } else {
            AssertionError e = new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
            ReferenceCountUtil.release(msg);
            promise.setFailure((Throwable)((Object)e));
            throw e;
        }
    }

    void returnProcessedBytes(Http2Stream http2Stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(http2Stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeStreamWhenDone(ChannelPromise promise, int streamId) throws Http2Exception {
        final NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                stream.complete();
            }
        });
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendResponseHeaders(ChannelHandlerContext ctx, SendResponseHeadersCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endOfStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeHeaders(ctx, cmd.streamId(), cmd.headers(), 0, cmd.endOfStream(), promise);
    }

    private void cancelStream(ChannelHandlerContext ctx, CancelServerStreamCommand cmd, ChannelPromise promise) {
        cmd.stream().abortStream(cmd.reason(), false);
        this.encoder().writeRstStream(ctx, cmd.stream().id(), Http2Error.CANCEL.code(), promise);
    }

    private void verifyContentType(int streamId, Http2Headers headers) throws Http2Exception {
        CharSequence contentType = (CharSequence)headers.get(Utils.CONTENT_TYPE_HEADER);
        if (contentType == null) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Content-Type is missing from the request", new Object[0]);
        }
        String contentTypeString = contentType.toString();
        if (!GrpcUtil.isGrpcContentType(contentTypeString)) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Content-Type '%s' is not supported", contentTypeString);
        }
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private String determineMethod(int streamId, Http2Headers headers) throws Http2Exception {
        if (!Utils.HTTP_METHOD.equals(headers.method())) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Method '%s' is not supported", headers.method());
        }
        NettyServerHandler.checkHeader(streamId, headers, Utils.CONTENT_TYPE_HEADER, Utils.CONTENT_TYPE_GRPC);
        CharSequence path = headers.path();
        if (path.charAt(0) != '/') {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Malformatted path: %s", path);
        }
        return path.subSequence(1, path.length()).toString();
    }

    private static void checkHeader(int streamId, Http2Headers headers, CharSequence header, CharSequence expectedValue) throws Http2Exception {
        if (!expectedValue.equals(headers.get(header))) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Header '%s'='%s', while '%s' is expected", header, headers.get(header), expectedValue);
        }
    }

    private NettyServerStream serverStream(Http2Stream stream) {
        return stream == null ? null : (NettyServerStream)stream.getProperty(this.streamKey);
    }

    private Http2Exception newStreamException(int streamId, Throwable cause) {
        return Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, cause, cause.getMessage(), new Object[0]);
    }

    private class FrameListener
    extends Http2FrameAdapter {
        private FrameListener() {
        }

        @Override
        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            NettyServerHandler.this.onDataRead(streamId, data, endOfStream);
            return padding;
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            NettyServerHandler.this.onHeadersRead(ctx, streamId, headers);
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            NettyServerHandler.this.onRstStreamRead(streamId);
        }
    }
}

