/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServerHandler;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private final Channel channel;
    private final ProtocolNegotiator protocolNegotiator;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final int maxStreams;
    private ServerTransportListener listener;
    private boolean terminated;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;

    NettyServerTransport(Channel channel, ProtocolNegotiator protocolNegotiator, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, int maxStreams, int flowControlWindow, int maxMessageSize, int maxHeaderListSize) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
        this.maxStreams = maxStreams;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.decompressorRegistry = Preconditions.checkNotNull(decompressorRegistry, "decompressorRegistry");
        this.compressorRegistry = Preconditions.checkNotNull(compressorRegistry, "compressorRegistry");
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState(this.listener == null, "Handler already registered");
        this.listener = listener;
        final NettyServerHandler grpcHandler = this.createHandler(listener);
        this.channel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerTransport.this.notifyTerminated(grpcHandler.connectionError());
            }
        });
        ProtocolNegotiator.Handler negotiationHandler = this.protocolNegotiator.newHandler(grpcHandler);
        this.channel.pipeline().addLast(negotiationHandler);
    }

    @Override
    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    Channel channel() {
        return this.channel;
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            log.log(Level.SEVERE, "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener) {
        return NettyServerHandler.newHandler(transportListener, this.decompressorRegistry, this.compressorRegistry, this.maxStreams, this.flowControlWindow, this.maxHeaderListSize, this.maxMessageSize);
    }
}

