/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.io.grpc.internal.AbstractStream;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBufHolder;
import com.google.bigtable.repackaged.io.netty.buffer.DefaultByteBufHolder;

class SendGrpcFrameCommand
extends DefaultByteBufHolder {
    private final AbstractStream<Integer> stream;
    private final boolean endStream;

    SendGrpcFrameCommand(AbstractStream<Integer> stream, ByteBuf content, boolean endStream) {
        super(content);
        this.stream = stream;
        this.endStream = endStream;
    }

    int streamId() {
        return this.stream.id();
    }

    boolean endStream() {
        return this.endStream;
    }

    @Override
    public ByteBufHolder copy() {
        return new SendGrpcFrameCommand(this.stream, this.content().copy(), this.endStream);
    }

    @Override
    public ByteBufHolder duplicate() {
        return new SendGrpcFrameCommand(this.stream, this.content().duplicate(), this.endStream);
    }

    @Override
    public SendGrpcFrameCommand retain() {
        super.retain();
        return this;
    }

    @Override
    public SendGrpcFrameCommand retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public SendGrpcFrameCommand touch() {
        super.touch();
        return this;
    }

    @Override
    public SendGrpcFrameCommand touch(Object hint) {
        super.touch(hint);
        return this;
    }

    public boolean equals(Object that) {
        if (that == null || !that.getClass().equals(SendGrpcFrameCommand.class)) {
            return false;
        }
        SendGrpcFrameCommand thatCmd = (SendGrpcFrameCommand)that;
        return thatCmd.stream.equals(this.stream) && thatCmd.endStream == this.endStream && thatCmd.content().equals(this.content());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(streamId=" + this.streamId() + ", endStream=" + this.endStream + ", content=" + this.content() + ")";
    }

    public int hashCode() {
        int hash = this.content().hashCode();
        hash = hash * 31 + this.stream.hashCode();
        if (this.endStream) {
            hash = -hash;
        }
        return hash;
    }
}

