/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelPromise;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class WriteQueue {
    private static final int DEQUE_CHUNK_SIZE = 128;
    private final Runnable later = new Runnable(){

        @Override
        public void run() {
            WriteQueue.this.flush();
        }
    };
    private final Channel channel;
    private final BlockingQueue<Runnable> queue;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final ArrayDeque<Runnable> writeChunk = new ArrayDeque(128);

    public WriteQueue(Channel channel) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.queue = new LinkedBlockingQueue<Runnable>();
    }

    void scheduleFlush() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.channel.eventLoop().execute(this.later);
        }
    }

    ChannelFuture enqueue(Object command, boolean flush) {
        return this.enqueue(command, this.channel.newPromise(), flush);
    }

    ChannelFuture enqueue(Object command, ChannelPromise promise, boolean flush) {
        this.queue.add(new QueuedCommand(command, promise));
        if (flush) {
            this.scheduleFlush();
        }
        return promise;
    }

    private void flush() {
        try {
            boolean flushed = false;
            while (this.queue.drainTo(this.writeChunk, 128) > 0) {
                while (this.writeChunk.size() > 0) {
                    this.writeChunk.poll().run();
                }
                flushed = true;
                this.channel.flush();
            }
            if (!flushed) {
                this.channel.flush();
            }
        }
        finally {
            this.scheduled.set(false);
            if (!this.queue.isEmpty()) {
                this.scheduleFlush();
            }
        }
    }

    private final class QueuedCommand
    implements Runnable {
        private final Object command;
        private final ChannelPromise promise;

        private QueuedCommand(Object command, ChannelPromise promise) {
            this.command = command;
            this.promise = promise;
        }

        @Override
        public void run() {
            WriteQueue.this.channel.write(this.command, this.promise);
        }
    }
}

