/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.protobuf;

import com.google.bigtable.repackaged.com.google.protobuf.CodedInputStream;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import com.google.bigtable.repackaged.com.google.protobuf.Parser;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.protobuf.ProtoInputStream;
import java.io.InputStream;

public class ProtoUtils {
    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        Parser<? extends MessageLite> parserGeneric;
        final Parser<? extends MessageLite> parser = parserGeneric = defaultInstance.getParserForType();
        return new MethodDescriptor.Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, parser);
            }

            @Override
            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    MessageLite message = ((ProtoInputStream)stream).message();
                    return message;
                }
                try {
                    return this.parseFrom(stream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
            }

            private T parseFrom(InputStream stream) throws InvalidProtocolBufferException {
                CodedInputStream codedInput = CodedInputStream.newInstance(stream);
                codedInput.setSizeLimit(Integer.MAX_VALUE);
                MessageLite message = (MessageLite)parser.parseFrom(codedInput);
                try {
                    codedInput.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends Message> Metadata.Key<T> keyForProto(final T instance) {
        return Metadata.Key.of(instance.getDescriptorForType().getFullName() + "-bin", new Metadata.BinaryMarshaller<T>(){

            @Override
            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            @Override
            public T parseBytes(byte[] serialized) {
                try {
                    return instance.getParserForType().parseFrom(serialized);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        });
    }

    private ProtoUtils() {
    }
}

