/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.stub;

import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractStub<S extends AbstractStub<S>> {
    private final Channel channel;
    private final CallOptions callOptions;

    protected AbstractStub(Channel channel) {
        this(channel, CallOptions.DEFAULT);
    }

    protected AbstractStub(Channel channel, CallOptions callOptions) {
        this.channel = channel;
        this.callOptions = callOptions;
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final CallOptions getCallOptions() {
        return this.callOptions;
    }

    protected abstract S build(Channel var1, CallOptions var2);

    public final S withDeadlineNanoTime(@Nullable Long deadlineNanoTime) {
        return this.build(this.channel, this.callOptions.withDeadlineNanoTime(deadlineNanoTime));
    }

    public final S withDeadlineAfter(long duration, TimeUnit unit) {
        return this.build(this.channel, this.callOptions.withDeadlineAfter(duration, unit));
    }

    public final S withChannel(Channel newChannel) {
        return this.build(newChannel, this.callOptions);
    }

    public final S withInterceptors(ClientInterceptor ... interceptors) {
        return this.build(ClientInterceptors.intercept(this.channel, interceptors), this.callOptions);
    }
}

