/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.channel;

import com.google.bigtable.repackaged.io.netty.channel.AbstractChannel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.netty.channel.ChannelInboundHandler;
import com.google.bigtable.repackaged.io.netty.channel.ChannelOutboundHandler;
import com.google.bigtable.repackaged.io.netty.channel.ChannelPromise;
import com.google.bigtable.repackaged.io.netty.channel.DefaultChannelPipeline;
import com.google.bigtable.repackaged.io.netty.channel.DefaultChannelPromise;
import com.google.bigtable.repackaged.io.netty.channel.VoidChannelPromise;
import com.google.bigtable.repackaged.io.netty.util.internal.StringUtil;
import java.net.SocketAddress;

public final class ChannelHandlerInvokerUtil {
    public static void invokeChannelRegisteredNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelRegistered(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelUnregisteredNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelUnregistered(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelActiveNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelActive(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelInactiveNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelInactive(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeExceptionCaughtNow(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                ctx.handler().exceptionCaught(ctx, cause);
            }
            catch (Throwable t) {
                if (!DefaultChannelPipeline.logger.isWarnEnabled()) break block2;
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler's exceptionCaught() method:", t);
                DefaultChannelPipeline.logger.warn(".. and the cause of the exceptionCaught() was:", cause);
            }
        }
    }

    public static void invokeUserEventTriggeredNow(ChannelHandlerContext ctx, Object event) {
        try {
            ((ChannelInboundHandler)ctx.handler()).userEventTriggered(ctx, event);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelReadNow(ChannelHandlerContext ctx, Object msg) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelRead(ctx, msg);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelReadCompleteNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelReadComplete(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelWritabilityChangedNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelInboundHandler)ctx.handler()).channelWritabilityChanged(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeBindNow(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).bind(ctx, localAddress, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeConnectNow(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).connect(ctx, remoteAddress, localAddress, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeDisconnectNow(ChannelHandlerContext ctx, ChannelPromise promise) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).disconnect(ctx, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeCloseNow(ChannelHandlerContext ctx, ChannelPromise promise) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).close(ctx, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeDeregisterNow(ChannelHandlerContext ctx, ChannelPromise promise) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).deregister(ctx, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeReadNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).read(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeWriteNow(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).write(ctx, msg, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeFlushNow(ChannelHandlerContext ctx) {
        try {
            ((ChannelOutboundHandler)ctx.handler()).flush(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static boolean validatePromise(ChannelHandlerContext ctx, ChannelPromise promise, boolean allowVoidPromise) {
        if (ctx == null) {
            throw new NullPointerException("ctx");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        if (promise.isDone()) {
            if (promise.isCancelled()) {
                return false;
            }
            throw new IllegalArgumentException("promise already done: " + promise);
        }
        if (promise.channel() != ctx.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", promise.channel(), ctx.channel()));
        }
        if (promise.getClass() == DefaultChannelPromise.class) {
            return true;
        }
        if (!allowVoidPromise && promise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (promise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return true;
    }

    private static void notifyHandlerException(ChannelHandlerContext ctx, Throwable cause) {
        if (ChannelHandlerInvokerUtil.inExceptionCaught(cause)) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", cause);
            }
            return;
        }
        ChannelHandlerInvokerUtil.invokeExceptionCaughtNow(ctx, cause);
    }

    private static void notifyOutboundHandlerException(Throwable cause, ChannelPromise promise) {
        if (!promise.tryFailure(cause) && !(promise instanceof VoidChannelPromise) && DefaultChannelPipeline.logger.isWarnEnabled()) {
            DefaultChannelPipeline.logger.warn("Failed to fail the promise because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    private static boolean inExceptionCaught(Throwable cause) {
        do {
            StackTraceElement[] trace;
            if ((trace = cause.getStackTrace()) == null) continue;
            for (StackTraceElement t : trace) {
                if (t == null) break;
                if (!"exceptionCaught".equals(t.getMethodName())) continue;
                return true;
            }
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private ChannelHandlerInvokerUtil() {
    }
}

