/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.channel.oio;

import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelConfig;
import com.google.bigtable.repackaged.io.netty.channel.ChannelPipeline;
import com.google.bigtable.repackaged.io.netty.channel.RecvByteBufAllocator;
import com.google.bigtable.repackaged.io.netty.channel.oio.AbstractOioChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOioMessageChannel
extends AbstractOioChannel {
    private final List<Object> readBuf = new ArrayList<Object>();

    protected AbstractOioMessageChannel(Channel parent) {
        super(parent);
    }

    @Override
    protected void doRead() {
        ChannelConfig config = this.config();
        if (!config.isAutoRead() && !this.isReadPending()) {
            return;
        }
        this.setReadPending(false);
        ChannelPipeline pipeline = this.pipeline();
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        allocHandle.reset(config);
        boolean closed = false;
        Throwable exception = null;
        try {
            int localRead;
            while ((localRead = this.doReadMessages(this.readBuf)) != 0) {
                if (localRead < 0) {
                    closed = true;
                } else {
                    allocHandle.incMessagesRead(localRead);
                    if (allocHandle.continueReading()) continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        int size = this.readBuf.size();
        for (int i = 0; i < size; ++i) {
            pipeline.fireChannelRead(this.readBuf.get(i));
        }
        this.readBuf.clear();
        allocHandle.readComplete();
        pipeline.fireChannelReadComplete();
        if (exception != null) {
            if (exception instanceof IOException) {
                closed = true;
            }
            pipeline.fireExceptionCaught(exception);
        }
        if (closed) {
            if (this.isOpen()) {
                this.unsafe().close(this.unsafe().voidPromise());
            }
        } else if (allocHandle.lastBytesRead() == 0 && this.isActive()) {
            this.read();
        }
    }

    protected abstract int doReadMessages(List<Object> var1) throws Exception;
}

