/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.handler.codec;

import com.google.bigtable.repackaged.io.netty.handler.codec.DefaultHeaders;
import com.google.bigtable.repackaged.io.netty.handler.codec.ValueConverter;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import com.google.bigtable.repackaged.io.netty.util.internal.PlatformDependent;
import java.text.ParseException;

public class CharSequenceValueConverter
implements ValueConverter<CharSequence> {
    public static final CharSequenceValueConverter INSTANCE = new CharSequenceValueConverter();

    @Override
    public CharSequence convertObject(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    @Override
    public CharSequence convertInt(int value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertLong(long value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertDouble(double value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertChar(char value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertFloat(float value) {
        return String.valueOf(value);
    }

    @Override
    public boolean convertToBoolean(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseBoolean();
        }
        return Boolean.parseBoolean(value.toString());
    }

    @Override
    public CharSequence convertByte(byte value) {
        return String.valueOf(value);
    }

    @Override
    public byte convertToByte(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).byteAt(0);
        }
        return Byte.valueOf(value.toString());
    }

    @Override
    public char convertToChar(CharSequence value) {
        return value.charAt(0);
    }

    @Override
    public CharSequence convertShort(short value) {
        return String.valueOf(value);
    }

    @Override
    public short convertToShort(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseShort();
        }
        return Short.valueOf(value.toString());
    }

    @Override
    public int convertToInt(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseInt();
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public long convertToLong(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseLong();
        }
        return Long.parseLong(value.toString());
    }

    @Override
    public CharSequence convertTimeMillis(long value) {
        return String.valueOf(value);
    }

    @Override
    public long convertToTimeMillis(CharSequence value) {
        try {
            return DefaultHeaders.HeaderDateFormat.get().parse(value.toString());
        }
        catch (ParseException e) {
            PlatformDependent.throwException(e);
            return 0L;
        }
    }

    @Override
    public float convertToFloat(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseFloat();
        }
        return Float.valueOf(value.toString()).floatValue();
    }

    @Override
    public double convertToDouble(CharSequence value) {
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseDouble();
        }
        return Double.valueOf(value.toString());
    }
}

