/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.resolver;

import com.google.bigtable.repackaged.io.netty.resolver.SimpleNameResolver;
import com.google.bigtable.repackaged.io.netty.util.concurrent.EventExecutor;
import com.google.bigtable.repackaged.io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class DefaultNameResolver
extends SimpleNameResolver<InetSocketAddress> {
    public DefaultNameResolver(EventExecutor executor) {
        super(executor);
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    @Override
    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        try {
            promise.setSuccess(new InetSocketAddress(InetAddress.getByName(unresolvedAddress.getHostName()), unresolvedAddress.getPort()));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }

    @Override
    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
        try {
            InetAddress[] resolved = InetAddress.getAllByName(unresolvedAddress.getHostName());
            ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(resolved.length);
            for (InetAddress a : resolved) {
                result.add(new InetSocketAddress(a, unresolvedAddress.getPort()));
            }
            promise.setSuccess(result);
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }
}

