/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.v1;

import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerServiceDefinition;
import com.google.bigtable.repackaged.io.grpc.protobuf.ProtoUtils;
import com.google.bigtable.repackaged.io.grpc.stub.AbstractStub;
import com.google.bigtable.repackaged.io.grpc.stub.ClientCalls;
import com.google.bigtable.repackaged.io.grpc.stub.ServerCalls;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.v1.CheckAndMutateRowRequest;
import com.google.bigtable.v1.CheckAndMutateRowResponse;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.MutateRowsRequest;
import com.google.bigtable.v1.MutateRowsResponse;
import com.google.bigtable.v1.ReadModifyWriteRowRequest;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.bigtable.v1.SampleRowKeysRequest;
import com.google.bigtable.v1.SampleRowKeysResponse;
import java.util.Iterator;

public class BigtableServiceGrpc {
    public static final String SERVICE_NAME = "google.bigtable.v1.BigtableService";
    public static final MethodDescriptor<ReadRowsRequest, ReadRowsResponse> METHOD_READ_ROWS = MethodDescriptor.create(MethodDescriptor.MethodType.SERVER_STREAMING, MethodDescriptor.generateFullMethodName("google.bigtable.v1.BigtableService", "ReadRows"), ProtoUtils.marshaller(ReadRowsRequest.getDefaultInstance()), ProtoUtils.marshaller(ReadRowsResponse.getDefaultInstance()));
    public static final MethodDescriptor<SampleRowKeysRequest, SampleRowKeysResponse> METHOD_SAMPLE_ROW_KEYS = MethodDescriptor.create(MethodDescriptor.MethodType.SERVER_STREAMING, MethodDescriptor.generateFullMethodName("google.bigtable.v1.BigtableService", "SampleRowKeys"), ProtoUtils.marshaller(SampleRowKeysRequest.getDefaultInstance()), ProtoUtils.marshaller(SampleRowKeysResponse.getDefaultInstance()));
    public static final MethodDescriptor<MutateRowRequest, Empty> METHOD_MUTATE_ROW = MethodDescriptor.create(MethodDescriptor.MethodType.UNARY, MethodDescriptor.generateFullMethodName("google.bigtable.v1.BigtableService", "MutateRow"), ProtoUtils.marshaller(MutateRowRequest.getDefaultInstance()), ProtoUtils.marshaller(Empty.getDefaultInstance()));
    public static final MethodDescriptor<MutateRowsRequest, MutateRowsResponse> METHOD_MUTATE_ROWS = MethodDescriptor.create(MethodDescriptor.MethodType.UNARY, MethodDescriptor.generateFullMethodName("google.bigtable.v1.BigtableService", "MutateRows"), ProtoUtils.marshaller(MutateRowsRequest.getDefaultInstance()), ProtoUtils.marshaller(MutateRowsResponse.getDefaultInstance()));
    public static final MethodDescriptor<CheckAndMutateRowRequest, CheckAndMutateRowResponse> METHOD_CHECK_AND_MUTATE_ROW = MethodDescriptor.create(MethodDescriptor.MethodType.UNARY, MethodDescriptor.generateFullMethodName("google.bigtable.v1.BigtableService", "CheckAndMutateRow"), ProtoUtils.marshaller(CheckAndMutateRowRequest.getDefaultInstance()), ProtoUtils.marshaller(CheckAndMutateRowResponse.getDefaultInstance()));
    public static final MethodDescriptor<ReadModifyWriteRowRequest, Row> METHOD_READ_MODIFY_WRITE_ROW = MethodDescriptor.create(MethodDescriptor.MethodType.UNARY, MethodDescriptor.generateFullMethodName("google.bigtable.v1.BigtableService", "ReadModifyWriteRow"), ProtoUtils.marshaller(ReadModifyWriteRowRequest.getDefaultInstance()), ProtoUtils.marshaller(Row.getDefaultInstance()));

    private BigtableServiceGrpc() {
    }

    public static BigtableServiceStub newStub(Channel channel) {
        return new BigtableServiceStub(channel);
    }

    public static BigtableServiceBlockingStub newBlockingStub(Channel channel) {
        return new BigtableServiceBlockingStub(channel);
    }

    public static BigtableServiceFutureStub newFutureStub(Channel channel) {
        return new BigtableServiceFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(final BigtableService serviceImpl) {
        return ServerServiceDefinition.builder(SERVICE_NAME).addMethod(METHOD_READ_ROWS, ServerCalls.asyncServerStreamingCall(new ServerCalls.ServerStreamingMethod<ReadRowsRequest, ReadRowsResponse>(){

            @Override
            public void invoke(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
                serviceImpl.readRows(request, responseObserver);
            }
        })).addMethod(METHOD_SAMPLE_ROW_KEYS, ServerCalls.asyncServerStreamingCall(new ServerCalls.ServerStreamingMethod<SampleRowKeysRequest, SampleRowKeysResponse>(){

            @Override
            public void invoke(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> responseObserver) {
                serviceImpl.sampleRowKeys(request, responseObserver);
            }
        })).addMethod(METHOD_MUTATE_ROW, ServerCalls.asyncUnaryCall(new ServerCalls.UnaryMethod<MutateRowRequest, Empty>(){

            @Override
            public void invoke(MutateRowRequest request, StreamObserver<Empty> responseObserver) {
                serviceImpl.mutateRow(request, responseObserver);
            }
        })).addMethod(METHOD_MUTATE_ROWS, ServerCalls.asyncUnaryCall(new ServerCalls.UnaryMethod<MutateRowsRequest, MutateRowsResponse>(){

            @Override
            public void invoke(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
                serviceImpl.mutateRows(request, responseObserver);
            }
        })).addMethod(METHOD_CHECK_AND_MUTATE_ROW, ServerCalls.asyncUnaryCall(new ServerCalls.UnaryMethod<CheckAndMutateRowRequest, CheckAndMutateRowResponse>(){

            @Override
            public void invoke(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> responseObserver) {
                serviceImpl.checkAndMutateRow(request, responseObserver);
            }
        })).addMethod(METHOD_READ_MODIFY_WRITE_ROW, ServerCalls.asyncUnaryCall(new ServerCalls.UnaryMethod<ReadModifyWriteRowRequest, Row>(){

            @Override
            public void invoke(ReadModifyWriteRowRequest request, StreamObserver<Row> responseObserver) {
                serviceImpl.readModifyWriteRow(request, responseObserver);
            }
        })).build();
    }

    public static class BigtableServiceFutureStub
    extends AbstractStub<BigtableServiceFutureStub>
    implements BigtableServiceFutureClient {
        private BigtableServiceFutureStub(Channel channel) {
            super(channel);
        }

        private BigtableServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        @Override
        protected BigtableServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new BigtableServiceFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<Empty> mutateRow(MutateRowRequest request) {
            return ClientCalls.futureUnaryCall(this.getChannel().newCall(METHOD_MUTATE_ROW, this.getCallOptions()), request);
        }

        @Override
        public ListenableFuture<MutateRowsResponse> mutateRows(MutateRowsRequest request) {
            return ClientCalls.futureUnaryCall(this.getChannel().newCall(METHOD_MUTATE_ROWS, this.getCallOptions()), request);
        }

        @Override
        public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRow(CheckAndMutateRowRequest request) {
            return ClientCalls.futureUnaryCall(this.getChannel().newCall(METHOD_CHECK_AND_MUTATE_ROW, this.getCallOptions()), request);
        }

        @Override
        public ListenableFuture<Row> readModifyWriteRow(ReadModifyWriteRowRequest request) {
            return ClientCalls.futureUnaryCall(this.getChannel().newCall(METHOD_READ_MODIFY_WRITE_ROW, this.getCallOptions()), request);
        }
    }

    public static class BigtableServiceBlockingStub
    extends AbstractStub<BigtableServiceBlockingStub>
    implements BigtableServiceBlockingClient {
        private BigtableServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private BigtableServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        @Override
        protected BigtableServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new BigtableServiceBlockingStub(channel, callOptions);
        }

        @Override
        public Iterator<ReadRowsResponse> readRows(ReadRowsRequest request) {
            return ClientCalls.blockingServerStreamingCall(this.getChannel().newCall(METHOD_READ_ROWS, this.getCallOptions()), request);
        }

        @Override
        public Iterator<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest request) {
            return ClientCalls.blockingServerStreamingCall(this.getChannel().newCall(METHOD_SAMPLE_ROW_KEYS, this.getCallOptions()), request);
        }

        @Override
        public Empty mutateRow(MutateRowRequest request) {
            return ClientCalls.blockingUnaryCall(this.getChannel().newCall(METHOD_MUTATE_ROW, this.getCallOptions()), request);
        }

        @Override
        public MutateRowsResponse mutateRows(MutateRowsRequest request) {
            return ClientCalls.blockingUnaryCall(this.getChannel().newCall(METHOD_MUTATE_ROWS, this.getCallOptions()), request);
        }

        @Override
        public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) {
            return ClientCalls.blockingUnaryCall(this.getChannel().newCall(METHOD_CHECK_AND_MUTATE_ROW, this.getCallOptions()), request);
        }

        @Override
        public Row readModifyWriteRow(ReadModifyWriteRowRequest request) {
            return ClientCalls.blockingUnaryCall(this.getChannel().newCall(METHOD_READ_MODIFY_WRITE_ROW, this.getCallOptions()), request);
        }
    }

    public static class BigtableServiceStub
    extends AbstractStub<BigtableServiceStub>
    implements BigtableService {
        private BigtableServiceStub(Channel channel) {
            super(channel);
        }

        private BigtableServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        @Override
        protected BigtableServiceStub build(Channel channel, CallOptions callOptions) {
            return new BigtableServiceStub(channel, callOptions);
        }

        @Override
        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall(this.getChannel().newCall(METHOD_READ_ROWS, this.getCallOptions()), request, responseObserver);
        }

        @Override
        public void sampleRowKeys(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall(this.getChannel().newCall(METHOD_SAMPLE_ROW_KEYS, this.getCallOptions()), request, responseObserver);
        }

        @Override
        public void mutateRow(MutateRowRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall(this.getChannel().newCall(METHOD_MUTATE_ROW, this.getCallOptions()), request, responseObserver);
        }

        @Override
        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            ClientCalls.asyncUnaryCall(this.getChannel().newCall(METHOD_MUTATE_ROWS, this.getCallOptions()), request, responseObserver);
        }

        @Override
        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> responseObserver) {
            ClientCalls.asyncUnaryCall(this.getChannel().newCall(METHOD_CHECK_AND_MUTATE_ROW, this.getCallOptions()), request, responseObserver);
        }

        @Override
        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<Row> responseObserver) {
            ClientCalls.asyncUnaryCall(this.getChannel().newCall(METHOD_READ_MODIFY_WRITE_ROW, this.getCallOptions()), request, responseObserver);
        }
    }

    public static interface BigtableServiceFutureClient {
        public ListenableFuture<Empty> mutateRow(MutateRowRequest var1);

        public ListenableFuture<MutateRowsResponse> mutateRows(MutateRowsRequest var1);

        public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRow(CheckAndMutateRowRequest var1);

        public ListenableFuture<Row> readModifyWriteRow(ReadModifyWriteRowRequest var1);
    }

    public static interface BigtableServiceBlockingClient {
        public Iterator<ReadRowsResponse> readRows(ReadRowsRequest var1);

        public Iterator<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest var1);

        public Empty mutateRow(MutateRowRequest var1);

        public MutateRowsResponse mutateRows(MutateRowsRequest var1);

        public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest var1);

        public Row readModifyWriteRow(ReadModifyWriteRowRequest var1);
    }

    public static interface BigtableService {
        public void readRows(ReadRowsRequest var1, StreamObserver<ReadRowsResponse> var2);

        public void sampleRowKeys(SampleRowKeysRequest var1, StreamObserver<SampleRowKeysResponse> var2);

        public void mutateRow(MutateRowRequest var1, StreamObserver<Empty> var2);

        public void mutateRows(MutateRowsRequest var1, StreamObserver<MutateRowsResponse> var2);

        public void checkAndMutateRow(CheckAndMutateRowRequest var1, StreamObserver<CheckAndMutateRowResponse> var2);

        public void readModifyWriteRow(ReadModifyWriteRowRequest var1, StreamObserver<Row> var2);
    }
}

