/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.api.client.util.Objects;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class BigtableOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BIGTABLE_TABLE_ADMIN_HOST_DEFAULT = "bigtabletableadmin.googleapis.com";
    public static final String BIGTABLE_CLUSTER_ADMIN_HOST_DEFAULT = "bigtableclusteradmin.googleapis.com";
    public static final String BIGTABLE_DATA_HOST_DEFAULT = "bigtable.googleapis.com";
    public static final int BIGTABLE_PORT_DEFAULT = 443;
    public static final int BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT = BigtableOptions.getDefaultDataChannelCount();
    public static final int BIGTABLE_CHANNEL_TIMEOUT_MS_DEFAULT = (int)TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES);
    public static final int BIGTABLE_ASYNC_MUTATOR_COUNT_DEFAULT = 2;
    private static final Logger LOG = new Logger(BigtableOptions.class);
    private final String clusterAdminHost;
    private final String tableAdminHost;
    private final String dataHost;
    private final int port;
    private final String projectId;
    private final String zoneId;
    private final String clusterId;
    private final CredentialOptions credentialOptions;
    private final String userAgent;
    private final RetryOptions retryOptions;
    private final int timeoutMs;
    private final int dataChannelCount;
    private final BigtableClusterName clusterName;
    private final int asyncMutatorCount;

    private static int getDefaultDataChannelCount() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return (int)Math.min(250.0, Math.max(1.0, Math.ceil((double)availableProcessors * 2.5)));
    }

    @VisibleForTesting
    BigtableOptions() {
        this.clusterAdminHost = null;
        this.tableAdminHost = null;
        this.dataHost = null;
        this.port = 0;
        this.projectId = null;
        this.zoneId = null;
        this.clusterId = null;
        this.credentialOptions = null;
        this.userAgent = null;
        this.retryOptions = null;
        this.timeoutMs = 0;
        this.dataChannelCount = 1;
        this.clusterName = null;
        this.asyncMutatorCount = 1;
    }

    private BigtableOptions(String clusterAdminHost, String tableAdminHost, String dataHost, int port, String projectId, String zoneId, String clusterId, CredentialOptions credentialOptions, String userAgent, RetryOptions retryOptions, int timeoutMs, int channelCount, int asyncMutatorCount) {
        Preconditions.checkArgument(channelCount > 0, "Channel count has to be at least 1.");
        Preconditions.checkArgument(timeoutMs >= -1, "ChannelTimeoutMs has to be positive, or -1 for none.");
        this.tableAdminHost = Preconditions.checkNotNull(tableAdminHost);
        this.clusterAdminHost = Preconditions.checkNotNull(clusterAdminHost);
        this.dataHost = Preconditions.checkNotNull(dataHost);
        this.port = port;
        this.projectId = projectId;
        this.zoneId = zoneId;
        this.clusterId = clusterId;
        this.credentialOptions = credentialOptions;
        this.userAgent = userAgent;
        this.retryOptions = retryOptions;
        this.timeoutMs = timeoutMs;
        this.dataChannelCount = channelCount;
        this.asyncMutatorCount = asyncMutatorCount;
        this.clusterName = !Strings.isNullOrEmpty(projectId) && !Strings.isNullOrEmpty(zoneId) && !Strings.isNullOrEmpty(clusterId) ? new BigtableClusterName(this.getProjectId(), this.getZoneId(), this.getClusterId()) : null;
        LOG.debug("Connection Configuration: projectId: %s, zoneId: %s, clusterId: %s, data host %s, table admin host %s, cluster admin host %s.", projectId, zoneId, clusterId, dataHost, tableAdminHost, clusterAdminHost);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDataHost() {
        return this.dataHost;
    }

    public String getTableAdminHost() {
        return this.tableAdminHost;
    }

    public String getClusterAdminHost() {
        return this.clusterAdminHost;
    }

    public int getPort() {
        return this.port;
    }

    public CredentialOptions getCredentialOptions() {
        return this.credentialOptions;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public int getChannelCount() {
        return this.dataChannelCount;
    }

    public BigtableClusterName getClusterName() {
        return this.clusterName;
    }

    public int getAsyncMutatorCount() {
        return this.asyncMutatorCount;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != BigtableOptions.class) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BigtableOptions other = (BigtableOptions)obj;
        return this.port == other.port && this.timeoutMs == other.timeoutMs && this.dataChannelCount == other.dataChannelCount && this.asyncMutatorCount == other.asyncMutatorCount && Objects.equal(this.clusterAdminHost, other.clusterAdminHost) && Objects.equal(this.tableAdminHost, other.tableAdminHost) && Objects.equal(this.dataHost, other.dataHost) && Objects.equal(this.projectId, other.projectId) && Objects.equal(this.zoneId, other.zoneId) && Objects.equal(this.clusterId, other.clusterId) && Objects.equal(this.userAgent, other.userAgent) && Objects.equal(this.credentialOptions, other.credentialOptions) && Objects.equal(this.retryOptions, other.retryOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("dataHost", this.dataHost).add("tableAdminHost", this.tableAdminHost).add("clusterAdminHost", this.clusterAdminHost).add("projectId", this.projectId).add("zoneId", this.zoneId).add("clusterId", this.clusterId).add("userAgent", this.userAgent).add("credentialType", (Object)this.credentialOptions.getCredentialType()).add("port", this.port).add("timeoutMs", this.timeoutMs).add("dataChannelCount", this.dataChannelCount).add("asyncMutatorCount", this.asyncMutatorCount).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String projectId;
        private String zoneId;
        private String clusterId;
        private String userAgent;
        private String dataHost = "bigtable.googleapis.com";
        private String tableAdminHost = "bigtabletableadmin.googleapis.com";
        private String clusterAdminHost = "bigtableclusteradmin.googleapis.com";
        private int port = 443;
        private CredentialOptions credentialOptions = CredentialOptions.defaultCredentials();
        private RetryOptions retryOptions = new RetryOptions.Builder().build();
        private int timeoutMs = BIGTABLE_CHANNEL_TIMEOUT_MS_DEFAULT;
        private int dataChannelCount = BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT;
        private int asyncMutatorCount = 2;

        public Builder() {
        }

        private Builder(BigtableOptions original) {
            this.projectId = original.projectId;
            this.zoneId = original.zoneId;
            this.clusterId = original.clusterId;
            this.userAgent = original.userAgent;
            this.dataHost = original.dataHost;
            this.tableAdminHost = original.tableAdminHost;
            this.clusterAdminHost = original.clusterAdminHost;
            this.port = original.port;
            this.credentialOptions = original.credentialOptions;
            this.retryOptions = original.retryOptions;
            this.timeoutMs = original.timeoutMs;
            this.dataChannelCount = original.dataChannelCount;
            this.asyncMutatorCount = original.asyncMutatorCount;
        }

        public Builder setTableAdminHost(String tableAdminHost) {
            this.tableAdminHost = tableAdminHost;
            return this;
        }

        public Builder setClusterAdminHost(String clusterAdminHost) {
            this.clusterAdminHost = clusterAdminHost;
            return this;
        }

        public Builder setDataHost(String dataHost) {
            this.dataHost = dataHost;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setZoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setCredentialOptions(CredentialOptions credentialOptions) {
            this.credentialOptions = credentialOptions;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setDataChannelCount(int dataChannelCount) {
            this.dataChannelCount = dataChannelCount;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setTimeoutMs(int timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public Builder setAsyncMutatorWorkerCount(int asyncMutatorCount) {
            Preconditions.checkArgument(asyncMutatorCount >= 0, "asyncMutatorCount must be greater or equal to 0.");
            this.asyncMutatorCount = asyncMutatorCount;
            return this;
        }

        public BigtableOptions build() {
            return new BigtableOptions(this.clusterAdminHost, this.tableAdminHost, this.dataHost, this.port, this.projectId, this.zoneId, this.clusterId, this.credentialOptions, this.userAgent, this.retryOptions, this.timeoutMs, this.dataChannelCount, this.asyncMutatorCount);
        }
    }
}

