/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.ExponentialBackOff;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class RetryOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int DEFAULT_STREAMING_BUFFER_SIZE = 60;
    public static int DEFAULT_STREAMING_BATCH_SIZE = DEFAULT_STREAMING_BUFFER_SIZE / 2;
    public static boolean ENABLE_GRPC_RETRIES_DEFAULT = true;
    public static boolean ENABLE_GRPC_RETRY_DEADLINE_EXCEEDED_DEFAULT = true;
    public static int DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS = (int)TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    public static final int DEFAULT_INITIAL_BACKOFF_MILLIS = 5;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 2.0;
    public static final int DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS = (int)TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final boolean retriesEnabled;
    private final boolean retryOnDeadlineExceeded;
    private final int initialBackoffMillis;
    private final int maxElaspedBackoffMillis;
    private final double backoffMultiplier;
    private final int streamingBufferSize;
    private final int streamingBatchSize;
    private final int readPartialRowTimeoutMillis;

    public RetryOptions(boolean retriesEnabled, boolean retryOnDeadlineExceeded, int initialBackoffMillis, double backoffMultiplier, int maxElaspedBackoffMillis, int streamingBufferSize, int streamingBatchSize, int readPartialRowTimeoutMillis) {
        this.retriesEnabled = retriesEnabled;
        this.retryOnDeadlineExceeded = retryOnDeadlineExceeded;
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxElaspedBackoffMillis = maxElaspedBackoffMillis;
        this.backoffMultiplier = backoffMultiplier;
        this.streamingBufferSize = streamingBufferSize;
        this.streamingBatchSize = streamingBatchSize;
        this.readPartialRowTimeoutMillis = readPartialRowTimeoutMillis;
    }

    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public int getMaxElaspedBackoffMillis() {
        return this.maxElaspedBackoffMillis;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public boolean enableRetries() {
        return this.retriesEnabled;
    }

    public boolean retryOnDeadlineExceeded() {
        return this.retryOnDeadlineExceeded;
    }

    public int getStreamingBufferSize() {
        return this.streamingBufferSize;
    }

    public int getStreamingBatchSize() {
        return this.streamingBatchSize;
    }

    public int getReadPartialRowTimeoutMillis() {
        return this.readPartialRowTimeoutMillis;
    }

    public boolean isRetryableRead(Status.Code code) {
        return code == Status.INTERNAL.getCode() || code == Status.UNAVAILABLE.getCode() || code == Status.ABORTED.getCode() || this.retryOnDeadlineExceeded && code == Status.DEADLINE_EXCEEDED.getCode();
    }

    public BackOff createBackoff() {
        return this.createBackoffBuilder().build();
    }

    @VisibleForTesting
    protected ExponentialBackOff.Builder createBackoffBuilder() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(this.getInitialBackoffMillis()).setMaxElapsedTimeMillis(this.getMaxElaspedBackoffMillis()).setMultiplier(this.getBackoffMultiplier());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RetryOptions.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RetryOptions other = (RetryOptions)obj;
        return this.retriesEnabled == other.retriesEnabled && this.retryOnDeadlineExceeded == other.retryOnDeadlineExceeded && this.initialBackoffMillis == other.initialBackoffMillis && this.maxElaspedBackoffMillis == other.maxElaspedBackoffMillis && this.backoffMultiplier == other.backoffMultiplier && this.streamingBufferSize == other.streamingBufferSize && this.streamingBatchSize == other.streamingBatchSize && this.readPartialRowTimeoutMillis == other.readPartialRowTimeoutMillis;
    }

    public static class Builder {
        private boolean enableRetries = ENABLE_GRPC_RETRIES_DEFAULT;
        private boolean retryOnDeadlineExceeded = ENABLE_GRPC_RETRY_DEADLINE_EXCEEDED_DEFAULT;
        private int initialBackoffMillis = 5;
        private double backoffMultiplier = 2.0;
        private int maxElaspedBackoffMillis = DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS;
        private int streamingBufferSize = DEFAULT_STREAMING_BUFFER_SIZE;
        private int streamingBatchSize = DEFAULT_STREAMING_BUFFER_SIZE;
        private int readPartialRowTimeoutMillis = DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS;

        public Builder setEnableRetries(boolean enabled) {
            this.enableRetries = enabled;
            return this;
        }

        public Builder setRetryOnDeadlineExceeded(boolean enabled) {
            this.retryOnDeadlineExceeded = enabled;
            return this;
        }

        public Builder setInitialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        public Builder setBackoffMultiplier(double multiplier) {
            this.backoffMultiplier = multiplier;
            return this;
        }

        public Builder setMaxElapsedBackoffMillis(int maxElaspedBackoffMillis) {
            this.maxElaspedBackoffMillis = maxElaspedBackoffMillis;
            return this;
        }

        public Builder setStreamingBufferSize(int streamingBufferSize) {
            this.streamingBufferSize = streamingBufferSize;
            return this;
        }

        public Builder setStreamingBatchSize(int streamingBatchSize) {
            this.streamingBatchSize = streamingBatchSize;
            return this;
        }

        public Builder setReadPartialRowTimeoutMillis(int timeout) {
            this.readPartialRowTimeoutMillis = timeout;
            return this;
        }

        public RetryOptions build() {
            return new RetryOptions(this.enableRetries, this.retryOnDeadlineExceeded, this.initialBackoffMillis, this.backoffMultiplier, this.maxElaspedBackoffMillis, this.streamingBufferSize, this.streamingBatchSize, this.readPartialRowTimeoutMillis);
        }
    }
}

