/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Predicate;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.com.google.protobuf.ServiceException;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.v1.BigtableServiceGrpc;
import com.google.bigtable.v1.CheckAndMutateRowRequest;
import com.google.bigtable.v1.CheckAndMutateRowResponse;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.Mutation;
import com.google.bigtable.v1.ReadModifyWriteRowRequest;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.bigtable.v1.SampleRowKeysRequest;
import com.google.bigtable.v1.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncUtilities;
import com.google.cloud.bigtable.grpc.async.RetryableRpc;
import com.google.cloud.bigtable.grpc.io.CancellationToken;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.io.ClientCallService;
import com.google.cloud.bigtable.grpc.io.RetryingCall;
import com.google.cloud.bigtable.grpc.scanner.BigtableResultScannerFactory;
import com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.grpc.scanner.ResumingStreamingResultScanner;
import com.google.cloud.bigtable.grpc.scanner.StreamingBigtableResultScanner;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public class BigtableDataGrpcClient
implements BigtableDataClient {
    private static final Logger LOG = new Logger(BigtableDataGrpcClient.class);
    @VisibleForTesting
    public static final Predicate<MutateRowRequest> IS_RETRYABLE_MUTATION = new Predicate<MutateRowRequest>(){

        @Override
        public boolean apply(@Nullable MutateRowRequest mutateRowRequest) {
            return mutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(mutateRowRequest.getMutationsList());
        }
    };
    @VisibleForTesting
    public static final Predicate<CheckAndMutateRowRequest> IS_RETRYABLE_CHECK_AND_MUTATE = new Predicate<CheckAndMutateRowRequest>(){

        @Override
        public boolean apply(@Nullable CheckAndMutateRowRequest checkAndMutateRowRequest) {
            return checkAndMutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getTrueMutationsList()) && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getFalseMutationsList());
        }
    };
    private final ChannelPool channelPool;
    private final ScheduledExecutorService retryExecutorService;
    private final ExecutorService executorService;
    private final RetryOptions retryOptions;
    private final BigtableOptions bigtableOptions;
    private final BigtableResultScannerFactory streamingScannerFactory = new BigtableResultScannerFactory(){

        @Override
        public ResultScanner<Row> createScanner(ReadRowsRequest request) {
            return BigtableDataGrpcClient.this.streamRows(request);
        }
    };
    private RetryableRpc<SampleRowKeysRequest, List<SampleRowKeysResponse>> sampleRowKeysAsync;
    private RetryableRpc<ReadRowsRequest, List<Row>> readRowsAsync;
    private ClientCallService clientCallService;

    private static final boolean allCellsHaveTimestamps(Iterable<Mutation> mutations) {
        for (Mutation mut : mutations) {
            if (mut.getSetCell().getTimestampMicros() != -1L) continue;
            return false;
        }
        return true;
    }

    public BigtableDataGrpcClient(ChannelPool channelPool, ExecutorService executorService, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        this(channelPool, executorService, retryExecutorService, bigtableOptions, ClientCallService.DEFAULT);
    }

    @VisibleForTesting
    BigtableDataGrpcClient(ChannelPool channelPool, ExecutorService executorService, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions, ClientCallService clientCallService) {
        this.channelPool = channelPool;
        this.executorService = executorService;
        this.bigtableOptions = bigtableOptions;
        this.retryOptions = bigtableOptions.getRetryOptions();
        this.clientCallService = clientCallService;
        this.retryExecutorService = retryExecutorService;
        this.sampleRowKeysAsync = BigtableAsyncUtilities.createSampleRowKeyAsyncReader(this.channelPool, clientCallService);
        this.readRowsAsync = BigtableAsyncUtilities.createRowKeyAysncReader(this.channelPool, clientCallService);
    }

    @Override
    public Empty mutateRow(MutateRowRequest request) throws ServiceException {
        return this.clientCallService.blockingUnaryCall(this.createMutateRowCall(request), request);
    }

    @Override
    public ListenableFuture<Empty> mutateRowAsync(MutateRowRequest request) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        return this.clientCallService.listenableAsyncCall(this.createMutateRowCall(request), request);
    }

    @Override
    public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) throws ServiceException {
        return this.clientCallService.blockingUnaryCall(this.createCheckAndMutateRowCall(request), request);
    }

    @Override
    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        return this.clientCallService.listenableAsyncCall(this.createCheckAndMutateRowCall(request), request);
    }

    private ClientCall<MutateRowRequest, Empty> createMutateRowCall(MutateRowRequest request) {
        return this.createRetryableCall(BigtableServiceGrpc.METHOD_MUTATE_ROW, IS_RETRYABLE_MUTATION, request);
    }

    private ClientCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse> createCheckAndMutateRowCall(CheckAndMutateRowRequest request) {
        return this.createRetryableCall(BigtableServiceGrpc.METHOD_CHECK_AND_MUTATE_ROW, IS_RETRYABLE_CHECK_AND_MUTATE, request);
    }

    private <ReqT, RespT> ClientCall<ReqT, RespT> createRetryableCall(MethodDescriptor<ReqT, RespT> method, Predicate<ReqT> isRetryable, ReqT request) {
        if (this.retryOptions.enableRetries() && isRetryable.apply(request)) {
            return new RetryingCall<ReqT, RespT>(this.channelPool, method, CallOptions.DEFAULT, this.retryExecutorService, this.retryOptions);
        }
        return this.channelPool.newCall(method, CallOptions.DEFAULT);
    }

    @Override
    public Row readModifyWriteRow(ReadModifyWriteRowRequest request) {
        return this.clientCallService.blockingUnaryCall(this.channelPool.newCall(BigtableServiceGrpc.METHOD_READ_MODIFY_WRITE_ROW, CallOptions.DEFAULT), request);
    }

    @Override
    public ListenableFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        return this.clientCallService.listenableAsyncCall(this.channelPool.newCall(BigtableServiceGrpc.METHOD_READ_MODIFY_WRITE_ROW, CallOptions.DEFAULT), request);
    }

    @Override
    public ImmutableList<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest request) {
        return ImmutableList.copyOf(this.clientCallService.blockingServerStreamingCall(this.channelPool.newCall(BigtableServiceGrpc.METHOD_SAMPLE_ROW_KEYS, CallOptions.DEFAULT), request));
    }

    @Override
    public ListenableFuture<List<SampleRowKeysResponse>> sampleRowKeysAsync(SampleRowKeysRequest request) {
        return BigtableAsyncUtilities.doReadAsync(this.retryOptions, request, this.sampleRowKeysAsync, this.executorService);
    }

    @Override
    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        return BigtableAsyncUtilities.doReadAsync(this.retryOptions, request, this.readRowsAsync, this.executorService);
    }

    @Override
    public ResultScanner<Row> readRows(ReadRowsRequest request) {
        if (this.retryOptions.enableRetries()) {
            return new ResumingStreamingResultScanner(this.retryOptions, request, this.streamingScannerFactory);
        }
        return this.streamRows(request);
    }

    private ResultScanner<Row> streamRows(ReadRowsRequest request) {
        int streamingBufferSize;
        int batchRequestSize;
        boolean isGet;
        boolean bl = isGet = request.getTargetCase() == ReadRowsRequest.TargetCase.ROW_KEY;
        if (isGet) {
            batchRequestSize = 1;
            streamingBufferSize = 10;
        } else {
            batchRequestSize = this.retryOptions.getStreamingBatchSize();
            streamingBufferSize = this.retryOptions.getStreamingBufferSize();
        }
        ClientCall<ReadRowsRequest, ReadRowsResponse> readRowsCall = this.channelPool.newCall(BigtableServiceGrpc.METHOD_READ_ROWS, CallOptions.DEFAULT);
        CancellationToken cancellationToken = this.createCancellationToken(readRowsCall);
        int timeout = this.retryOptions.getReadPartialRowTimeoutMillis();
        ResponseQueueReader responseQueueReader = new ResponseQueueReader(timeout, streamingBufferSize, batchRequestSize, batchRequestSize, readRowsCall);
        StreamingBigtableResultScanner resultScanner = new StreamingBigtableResultScanner(responseQueueReader, cancellationToken);
        this.clientCallService.asyncServerStreamingCall(readRowsCall, request, this.createClientCallListener(resultScanner));
        if (batchRequestSize > 1) {
            readRowsCall.request(batchRequestSize - 1);
        }
        return resultScanner;
    }

    private CancellationToken createCancellationToken(final ClientCall<ReadRowsRequest, ReadRowsResponse> readRowsCall) {
        CancellationToken cancellationToken = new CancellationToken();
        cancellationToken.addListener(new Runnable(){

            @Override
            public void run() {
                readRowsCall.cancel();
            }
        }, this.executorService);
        return cancellationToken;
    }

    private ClientCall.Listener<ReadRowsResponse> createClientCallListener(final StreamingBigtableResultScanner resultScanner) {
        return new ClientCall.Listener<ReadRowsResponse>(){

            @Override
            public void onMessage(ReadRowsResponse readRowResponse) {
                resultScanner.addResult(readRowResponse);
            }

            @Override
            public void onClose(Status status, Metadata trailers) {
                if (status.isOk()) {
                    resultScanner.complete();
                } else {
                    resultScanner.setError(status.asRuntimeException());
                }
            }
        };
    }

    private void expandPoolIfNecessary(int channelCount) {
        try {
            this.channelPool.ensureChannelCount(channelCount);
        }
        catch (IOException e) {
            LOG.info("Could not expand the channel pool.", e);
        }
    }
}

