/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedChannelImpl;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.NegotiationType;
import com.google.bigtable.repackaged.io.grpc.netty.NettyChannelBuilder;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.nio.NioEventLoopGroup;
import com.google.bigtable.repackaged.io.netty.handler.ssl.OpenSsl;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContext;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContextBuilder;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialFactory;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.BigtableClusterAdminClient;
import com.google.cloud.bigtable.grpc.BigtableClusterAdminGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableDataGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.BigtableTableAdminGrpcClient;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.io.CredentialInterceptorCache;
import com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import com.google.cloud.bigtable.grpc.io.ReconnectingChannel;
import com.google.cloud.bigtable.grpc.io.UserAgentInterceptor;
import com.google.cloud.bigtable.util.ThreadPoolUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public class BigtableSession
implements AutoCloseable {
    public static final String BATCH_POOL_THREAD_NAME = "bigtable-batch-pool";
    public static final String RETRY_THREADPOOL_NAME = "bigtable-rpc-retry";
    public static final int RETRY_THREAD_COUNT = 4;
    public static final String GRPC_EVENTLOOP_GROUP_NAME = "bigtable-grpc-elg";
    private static final Logger LOG = new Logger(BigtableSession.class);
    private static SslContextBuilder sslBuilder;
    @VisibleForTesting
    static final String PROJECT_ID_EMPTY_OR_NULL = "ProjectId must not be empty or null.";
    @VisibleForTesting
    static final String ZONE_ID_EMPTY_OR_NULL = "ZoneId must not be empty or null.";
    @VisibleForTesting
    static final String CLUSTER_ID_EMPTY_OR_NULL = "ClusterId must not be empty or null.";
    @VisibleForTesting
    static final String USER_AGENT_EMPTY_OR_NULL = "UserAgent must not be empty or null";
    private BigtableDataClient dataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableClusterAdminClient clusterAdminClient;
    private final BigtableOptions options;
    private final ExecutorService batchPool;
    private final boolean terminateBatchPool;
    private final EventLoopGroup elg;
    private final ScheduledExecutorService scheduledRetries;
    private final List<Closeable> clientCloseHandlers = Collections.synchronizedList(new ArrayList());
    private final ImmutableList<HeaderInterceptor> headerInterceptors;

    private static synchronized SslContext createSslContext() throws SSLException {
        if (sslBuilder == null) {
            sslBuilder = GrpcSslContexts.forClient().ciphers(null);
            if (OpenSsl.isAvailable()) {
                LOG.info("gRPC is using the OpenSSL provider (tcnactive jar - Open Ssl version: %s)", OpenSsl.versionString());
            } else if (BigtableSession.isJettyAlpnConfigured()) {
                LOG.info("gRPC is using the JDK provider (alpn-boot jar)", new Object[0]);
            } else {
                LOG.info("gRPC cannot be configured.  Neither OpenSsl nor Alpn are available.", new Object[0]);
            }
        }
        return sslBuilder.build();
    }

    public static boolean isAlpnProviderEnabled() {
        boolean openSslAvailable = OpenSsl.isAvailable();
        boolean jettyAlpnConfigured = BigtableSession.isJettyAlpnConfigured();
        LOG.debug("OpenSSL available: %s", openSslAvailable);
        LOG.debug("Jetty ALPN available: %s", jettyAlpnConfigured);
        return openSslAvailable || jettyAlpnConfigured;
    }

    private static boolean isJettyAlpnConfigured() {
        String alpnClassName = "org.eclipse.jetty.alpn.ALPN";
        try {
            Class.forName("org.eclipse.jetty.alpn.ALPN", true, null);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Exception e) {
            LOG.warn("Could not resolve alpn class: %s", e, "org.eclipse.jetty.alpn.ALPN");
            return false;
        }
    }

    private static void performWarmup() {
        ExecutorService connectionStartupExecutor = Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("BigtableSession-startup"));
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (BigtableSession.isAlpnProviderEnabled()) {
                    try {
                        BigtableSession.createSslContext();
                    }
                    catch (SSLException e) {
                        LOG.warn("Could not asynchronously create the ssl context", e, new Object[0]);
                    }
                }
            }
        });
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CredentialFactory.getHttpTransport();
                }
                catch (IOException | GeneralSecurityException e) {
                    LOG.warn("Could not asynchronously initialze httpTransport", e, new Object[0]);
                }
            }
        });
        for (final String host : Arrays.asList("bigtable.googleapis.com", "bigtableclusteradmin.googleapis.com", "bigtableclusteradmin.googleapis.com")) {
            connectionStartupExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        InetAddress.getByName(host);
                    }
                    catch (UnknownHostException e) {
                        LOG.warn("Could not asynchronously initialze host: " + host, e, new Object[0]);
                    }
                }
            });
        }
        connectionStartupExecutor.shutdown();
    }

    protected static ExecutorService createDefaultBatchPool() {
        return Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory(BATCH_POOL_THREAD_NAME));
    }

    protected static EventLoopGroup createDefaultEventLoopGroup() {
        return new NioEventLoopGroup(0, ThreadPoolUtil.createThreadFactory(GRPC_EVENTLOOP_GROUP_NAME));
    }

    protected static ScheduledExecutorService createDefaultRetryExecutor() {
        return Executors.newScheduledThreadPool(4, ThreadPoolUtil.createThreadFactory(RETRY_THREADPOOL_NAME));
    }

    public BigtableSession(BigtableOptions options) throws IOException {
        this(options, null, null, null);
    }

    public BigtableSession(BigtableOptions options, ExecutorService batchPool) throws IOException {
        this(options, batchPool, null, null);
    }

    public BigtableSession(BigtableOptions options, @Nullable ExecutorService batchPool, @Nullable EventLoopGroup elg, @Nullable ScheduledExecutorService scheduledRetries) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getProjectId()), PROJECT_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getZoneId()), ZONE_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getClusterId()), CLUSTER_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getUserAgent()), USER_AGENT_EMPTY_OR_NULL);
        LOG.info("Opening connection for projectId %s, zoneId %s, clusterId %s, on data host %s, table admin host %s.", options.getProjectId(), options.getZoneId(), options.getClusterId(), options.getDataHost(), options.getTableAdminHost());
        if (!BigtableSession.isAlpnProviderEnabled()) {
            LOG.error("Neither Jetty ALPN nor OpenSSL are available. OpenSSL unavailability cause:\n%s", OpenSsl.unavailabilityCause().toString());
            throw new IllegalStateException("Neither Jetty ALPN nor OpenSSL via netty-tcnative were properly configured.");
        }
        if (batchPool == null) {
            this.terminateBatchPool = true;
            this.batchPool = BigtableSession.createDefaultBatchPool();
        } else {
            this.terminateBatchPool = false;
            this.batchPool = batchPool;
        }
        this.options = options;
        ImmutableList.Builder<HeaderInterceptor> headerInterceptorBuilder = new ImmutableList.Builder<HeaderInterceptor>();
        Future<Void> credentialsFuture = this.batchPool.submit(this.createCredentialsCallback(headerInterceptorBuilder));
        this.elg = elg == null ? BigtableSession.createDefaultEventLoopGroup() : elg;
        this.scheduledRetries = scheduledRetries == null ? BigtableSession.createDefaultRetryExecutor() : scheduledRetries;
        headerInterceptorBuilder.add((Object)new UserAgentInterceptor(options.getUserAgent()));
        BigtableSession.get(credentialsFuture, "Could not initialize credentials");
        this.headerInterceptors = headerInterceptorBuilder.build();
        Future<BigtableDataClient> dataClientFuture = this.batchPool.submit(new Callable<BigtableDataClient>(){

            @Override
            public BigtableDataClient call() throws Exception {
                return BigtableSession.this.initializeDataClient();
            }
        });
        Future<BigtableTableAdminClient> tableAdminFuture = this.batchPool.submit(new Callable<BigtableTableAdminClient>(){

            @Override
            public BigtableTableAdminClient call() throws Exception {
                return BigtableSession.this.initializeAdminClient();
            }
        });
        this.dataClient = BigtableSession.get(dataClientFuture, "Could not initialize the data API client");
        this.tableAdminClient = BigtableSession.get(tableAdminFuture, "Could not initialize the table Admin client");
    }

    protected Callable<Void> createCredentialsCallback(final ImmutableList.Builder<HeaderInterceptor> headerInterceptorBuilder) {
        return new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    CredentialInterceptorCache credentialsCache = CredentialInterceptorCache.getInstance();
                    RetryOptions retryOptions = BigtableSession.this.options.getRetryOptions();
                    CredentialOptions credentialOptions = BigtableSession.this.options.getCredentialOptions();
                    HeaderInterceptor headerInterceptor = credentialsCache.getCredentialsInterceptor(credentialOptions, retryOptions);
                    if (headerInterceptor != null) {
                        headerInterceptorBuilder.add(headerInterceptor);
                    }
                    return null;
                }
                catch (GeneralSecurityException e) {
                    throw new IOException("Could not load auth credentials", e);
                }
            }
        };
    }

    private BigtableDataClient initializeDataClient() throws IOException {
        ChannelPool dataChannel = this.createChannel(this.options.getDataHost());
        return new BigtableDataGrpcClient(dataChannel, this.batchPool, this.scheduledRetries, this.options);
    }

    private BigtableTableAdminClient initializeAdminClient() throws IOException {
        ChannelPool channel = this.createChannel(this.options.getTableAdminHost());
        return new BigtableTableAdminGrpcClient(channel);
    }

    private static <T> T get(Future<T> future, String errorMessage) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new IOException(errorMessage, e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(errorMessage, e);
        }
    }

    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    public BigtableTableAdminClient getTableAdminClient() {
        return this.tableAdminClient;
    }

    public synchronized BigtableClusterAdminClient getClusterAdminClient() throws IOException {
        if (this.clusterAdminClient == null) {
            ChannelPool channel = this.createChannel(this.options.getClusterAdminHost());
            this.clusterAdminClient = new BigtableClusterAdminGrpcClient(channel);
        }
        return this.clusterAdminClient;
    }

    protected ChannelPool createChannel(final String hostString) throws IOException {
        return new ChannelPool(this.headerInterceptors, new ChannelPool.ChannelFactory(){

            @Override
            public Channel create() throws IOException {
                ReconnectingChannel reconnectingChannel = BigtableSession.this.createReconnectingChannel(hostString);
                BigtableSession.this.clientCloseHandlers.add(reconnectingChannel);
                return reconnectingChannel;
            }
        });
    }

    protected ReconnectingChannel createReconnectingChannel(final String host) throws IOException {
        return new ReconnectingChannel(this.options.getTimeoutMs(), new ReconnectingChannel.Factory(){

            @Override
            public Channel createChannel() throws IOException {
                return ((NettyChannelBuilder)NettyChannelBuilder.forAddress(host, BigtableSession.this.options.getPort()).maxMessageSize(0x10000000).sslContext(BigtableSession.createSslContext()).eventLoopGroup(BigtableSession.this.elg).executor(BigtableSession.this.batchPool)).negotiationType(NegotiationType.TLS).flowControlWindow(0x100000).build();
            }

            @Override
            public Closeable createClosable(final Channel channel) {
                return new Closeable(){

                    @Override
                    public void close() throws IOException {
                        ManagedChannelImpl channelImpl = (ManagedChannelImpl)channel;
                        channelImpl.shutdown();
                        int timeoutMs = 10000;
                        try {
                            channelImpl.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw new IOException("Interrupted while sleeping for close", e);
                        }
                        if (!channelImpl.isTerminated()) {
                            LOG.trace("Could not close the channel after %d ms.", timeoutMs);
                        }
                    }
                };
            }
        });
    }

    @Override
    public void close() throws IOException {
        ArrayList<ListenableFuture<Void>> closingChannelsFutures = new ArrayList<ListenableFuture<Void>>();
        ListeningExecutorService listenableBatchPool = MoreExecutors.listeningDecorator(this.batchPool);
        for (final Closeable clientCloseHandler : this.clientCloseHandlers) {
            closingChannelsFutures.add(listenableBatchPool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    clientCloseHandler.close();
                    return null;
                }
            }));
        }
        try {
            Futures.allAsList(closingChannelsFutures).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("Interrupted while waiting for channels to be closed", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Exception while waiting for channels to be closed", e);
        }
        this.elg.shutdownGracefully();
        this.scheduledRetries.shutdown();
        BigtableSession.awaiteTerminated(this.scheduledRetries);
        if (this.terminateBatchPool) {
            this.batchPool.shutdown();
            BigtableSession.awaiteTerminated(this.batchPool);
        }
    }

    private static void awaiteTerminated(ExecutorService executorService) {
        while (!executorService.isTerminated()) {
            MoreExecutors.shutdownAndAwaitTermination(executorService, 5L, TimeUnit.SECONDS);
        }
    }

    static {
        BigtableSession.performWarmup();
    }
}

