/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.bigtable.v1.CheckAndMutateRowRequest;
import com.google.bigtable.v1.CheckAndMutateRowResponse;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.ReadModifyWriteRowRequest;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.Row;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.async.HeapSizeManager;
import java.io.IOException;
import java.util.List;

public class AsyncExecutor {
    public static final int MAX_INFLIGHT_RPCS_DEFAULT = 50;
    public static final long ASYNC_MUTATOR_MAX_MEMORY_DEFAULT = (long)Math.min(1.073741824E9, (double)Runtime.getRuntime().maxMemory() * 0.1);
    protected static final Logger LOG = new Logger(AsyncExecutor.class);
    protected static AsyncCall<MutateRowRequest, Empty> MUTATE_ASYNC = new AsyncCall<MutateRowRequest, Empty>(){

        @Override
        public ListenableFuture<Empty> call(BigtableDataClient client, MutateRowRequest request) {
            return client.mutateRowAsync(request);
        }
    };
    protected static AsyncCall<ReadModifyWriteRowRequest, Row> READ_MODIFY_WRITE_ASYNC = new AsyncCall<ReadModifyWriteRowRequest, Row>(){

        @Override
        public ListenableFuture<Row> call(BigtableDataClient client, ReadModifyWriteRowRequest request) {
            return client.readModifyWriteRowAsync(request);
        }
    };
    protected static AsyncCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse> CHECK_AND_MUTATE_ASYNC = new AsyncCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse>(){

        @Override
        public ListenableFuture<CheckAndMutateRowResponse> call(BigtableDataClient client, CheckAndMutateRowRequest request) {
            return client.checkAndMutateRowAsync(request);
        }
    };
    protected static AsyncCall<ReadRowsRequest, List<Row>> READ_ROWS_ASYNC = new AsyncCall<ReadRowsRequest, List<Row>>(){

        @Override
        public ListenableFuture<List<Row>> call(BigtableDataClient client, ReadRowsRequest request) {
            return client.readRowsAsync(request);
        }
    };
    private final BigtableDataClient client;
    private final HeapSizeManager sizeManager;

    public AsyncExecutor(BigtableDataClient client, HeapSizeManager heapSizeManager) {
        this.client = client;
        this.sizeManager = heapSizeManager;
    }

    public ListenableFuture<Empty> mutateRowAsync(MutateRowRequest request, long operationId) {
        return this.call(MUTATE_ASYNC, request, operationId);
    }

    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request, long operationId) {
        return this.call(CHECK_AND_MUTATE_ASYNC, request, operationId);
    }

    public ListenableFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRowRequest request, long operationId) {
        return this.call(READ_MODIFY_WRITE_ASYNC, request, operationId);
    }

    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request, long operationId) {
        return this.call(READ_ROWS_ASYNC, request, operationId);
    }

    public ListenableFuture<Empty> mutateRowAsync(MutateRowRequest request) throws InterruptedException {
        return this.call(MUTATE_ASYNC, request);
    }

    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) throws InterruptedException {
        return this.call(CHECK_AND_MUTATE_ASYNC, request);
    }

    public ListenableFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) throws InterruptedException {
        return this.call(READ_MODIFY_WRITE_ASYNC, request);
    }

    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) throws InterruptedException {
        return this.call(READ_ROWS_ASYNC, request);
    }

    private <RequestT extends GeneratedMessage, ResponseT> ListenableFuture<ResponseT> call(AsyncCall<RequestT, ResponseT> rpc, RequestT request) throws InterruptedException {
        long id = this.sizeManager.registerOperationWithHeapSize(request.getSerializedSize());
        return this.call(rpc, request, id);
    }

    private <ResponseT, RequestT extends GeneratedMessage> ListenableFuture<ResponseT> call(AsyncCall<RequestT, ResponseT> rpc, RequestT request, long id) {
        ListenableFuture<Object> future;
        try {
            future = rpc.call(this.client, request);
        }
        catch (Exception e) {
            future = Futures.immediateFailedFuture(e);
        }
        this.sizeManager.addCallback(future, id);
        return future;
    }

    public void flush() throws IOException {
        LOG.trace("Flushing", new Object[0]);
        try {
            this.sizeManager.flush();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Batch operations were interrupted.");
        }
        LOG.trace("Done flushing", new Object[0]);
    }

    public boolean hasInflightRequests() {
        return this.sizeManager.hasInflightRequests();
    }

    public long getMaxHeapSize() {
        return this.sizeManager.getMaxHeapSize();
    }

    protected static interface AsyncCall<RequestT, ResponseT> {
        public ListenableFuture<ResponseT> call(BigtableDataClient var1, RequestT var2);
    }
}

