/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.v1.BigtableServiceGrpc;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.bigtable.v1.SampleRowKeysRequest;
import com.google.bigtable.v1.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.async.CollectingStreamObserver;
import com.google.cloud.bigtable.grpc.async.RetryableRpc;
import com.google.cloud.bigtable.grpc.async.RetryingRpcFunction;
import com.google.cloud.bigtable.grpc.io.ClientCallService;
import com.google.cloud.bigtable.grpc.scanner.RowMerger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class BigtableAsyncUtilities {
    private static final Function<List<SampleRowKeysResponse>, List<SampleRowKeysResponse>> IMMUTABLE_LIST_TRANSFORMER = new Function<List<SampleRowKeysResponse>, List<SampleRowKeysResponse>>(){

        @Override
        public List<SampleRowKeysResponse> apply(List<SampleRowKeysResponse> list) {
            return ImmutableList.copyOf(list);
        }
    };
    private static Function<List<ReadRowsResponse>, List<Row>> ROW_TRANSFORMER = new Function<List<ReadRowsResponse>, List<Row>>(){

        @Override
        public List<Row> apply(List<ReadRowsResponse> responses) {
            ArrayList<Row> result = new ArrayList<Row>();
            Iterator<ReadRowsResponse> responseIterator = responses.iterator();
            while (responseIterator.hasNext()) {
                result.add(RowMerger.readNextRow(responseIterator));
            }
            return result;
        }
    };

    public static RetryableRpc<SampleRowKeysRequest, List<SampleRowKeysResponse>> createSampleRowKeyAsyncReader(Channel channel, ClientCallService clientCallService) {
        return BigtableAsyncUtilities.createStreamingAsync(channel, BigtableServiceGrpc.METHOD_SAMPLE_ROW_KEYS, IMMUTABLE_LIST_TRANSFORMER, clientCallService);
    }

    public static RetryableRpc<ReadRowsRequest, List<Row>> createRowKeyAysncReader(Channel channel, ClientCallService clientCallService) {
        return BigtableAsyncUtilities.createStreamingAsync(channel, BigtableServiceGrpc.METHOD_READ_ROWS, ROW_TRANSFORMER, clientCallService);
    }

    private static <RequestT, ResponseT, OutputT> RetryableRpc<RequestT, List<OutputT>> createStreamingAsync(final Channel channel, final MethodDescriptor<RequestT, ResponseT> method, final Function<List<ResponseT>, List<OutputT>> function, final ClientCallService clientCallService) {
        return new RetryableRpc<RequestT, List<OutputT>>(){

            @Override
            public ListenableFuture<List<OutputT>> call(RequestT request) {
                ClientCall readRowsCall = channel.newCall(method, CallOptions.DEFAULT);
                CollectingStreamObserver responseCollector = new CollectingStreamObserver();
                clientCallService.asyncServerStreamingCall(readRowsCall, request, responseCollector);
                return Futures.transform(responseCollector.getResponseCompleteFuture(), function);
            }
        };
    }

    public static <RequestT, ResponseT> ListenableFuture<ResponseT> doReadAsync(RetryOptions retryOptions, RequestT request, RetryableRpc<RequestT, ResponseT> rpc, ExecutorService executorService) {
        ListenableFuture<ResponseT> listenableFuture = rpc.call(request);
        if (retryOptions.enableRetries()) {
            return Futures.catchingAsync(listenableFuture, StatusRuntimeException.class, RetryingRpcFunction.create(retryOptions, request, rpc), executorService);
        }
        return listenableFuture;
    }

    private BigtableAsyncUtilities() {
    }
}

