/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;

public class CollectingStreamObserver<T>
implements StreamObserver<T> {
    private final SettableFuture<List<T>> responseCompleteFuture = SettableFuture.create();
    private final List<T> buffer = new ArrayList<T>();

    public ListenableFuture<List<T>> getResponseCompleteFuture() {
        return this.responseCompleteFuture;
    }

    @Override
    public void onNext(T value) {
        this.buffer.add(value);
    }

    @Override
    public void onError(Throwable throwable) {
        this.responseCompleteFuture.setException(throwable);
    }

    @Override
    public void onCompleted() {
        this.responseCompleteFuture.set(this.buffer);
    }
}

