/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.cloud.bigtable.config.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class HeapSizeManager {
    protected static final Logger LOG = new Logger(HeapSizeManager.class);
    private static final long FINISH_WAIT_MILLIS = 250L;
    private static final long REGISTER_WAIT_MILLIS = 5L;
    private static final long INTERVAL_NO_SUCCESS_WARNING = 300000L;
    private final long maxHeapSize;
    private final int maxInFlightRpcs;
    private final Map<Long, Long> pendingOperationsWithSize = new HashMap<Long, Long>();
    private final LinkedBlockingDeque<Long> completedOperationIds = new LinkedBlockingDeque();
    private long currentWriteBufferSize = 0L;
    private AtomicLong operationSequenceGenerator = new AtomicLong();
    private long lastOperationChange = System.currentTimeMillis();

    public HeapSizeManager(long maxHeapSize, int maxInflightRpcs) {
        this.maxHeapSize = maxHeapSize;
        this.maxInFlightRpcs = maxInflightRpcs;
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxInFlightRpcs() {
        return this.maxInFlightRpcs;
    }

    public synchronized void flush() throws InterruptedException {
        boolean performedWarning = false;
        this.cleanupFinishedOperations();
        while (!this.pendingOperationsWithSize.isEmpty()) {
            if (!performedWarning && this.lastOperationChange + 300000L < System.currentTimeMillis()) {
                long lastUpdated = (System.currentTimeMillis() - this.lastOperationChange) / 1000L;
                LOG.warn("No operations completed within the last %d seconds. There are still %d operations in progress.", lastUpdated, this.pendingOperationsWithSize.size());
                performedWarning = true;
            }
            this.waitForCompletions(250L);
            this.cleanupFinishedOperations();
        }
        if (performedWarning) {
            LOG.info("flush() completed", new Object[0]);
        }
    }

    private void cleanupFinishedOperations() {
        ArrayList<Long> toClean = new ArrayList<Long>();
        this.completedOperationIds.drainTo(toClean);
        if (!toClean.isEmpty()) {
            this.markOperationsCompleted(toClean);
        }
    }

    public synchronized long registerOperationWithHeapSize(long heapSize) throws InterruptedException {
        long operationId = this.operationSequenceGenerator.incrementAndGet();
        while (this.unsynchronizedIsFull()) {
            this.waitForCompletions(5L);
        }
        this.lastOperationChange = System.currentTimeMillis();
        this.pendingOperationsWithSize.put(operationId, heapSize);
        this.currentWriteBufferSize += heapSize;
        return operationId;
    }

    private void waitForCompletions(long timeoutMs) throws InterruptedException {
        Long completedOperation = this.completedOperationIds.pollFirst(timeoutMs, TimeUnit.MILLISECONDS);
        if (completedOperation != null) {
            this.markOperationComplete(completedOperation);
        }
    }

    public synchronized boolean isFull() {
        return this.unsynchronizedIsFull();
    }

    private boolean unsynchronizedIsFull() {
        if (!this.isFullInternal()) {
            return false;
        }
        this.cleanupFinishedOperations();
        return this.isFullInternal();
    }

    private boolean isFullInternal() {
        return this.currentWriteBufferSize >= this.maxHeapSize || this.pendingOperationsWithSize.size() >= this.maxInFlightRpcs;
    }

    private synchronized void markOperationsCompleted(List<Long> operationSequenceIds) {
        for (Long operationSequenceId : operationSequenceIds) {
            this.markOperationComplete(operationSequenceId);
        }
        this.lastOperationChange = System.currentTimeMillis();
        this.notifyAll();
    }

    private void markOperationComplete(Long operationSequenceId) {
        Long heapSize = this.pendingOperationsWithSize.remove(operationSequenceId);
        if (heapSize != null) {
            this.currentWriteBufferSize -= heapSize.longValue();
        } else {
            LOG.warn("An operation completion was recieved multiple times. Your operations completed. Please notify Google that this occurred.", new Object[0]);
        }
    }

    public synchronized boolean hasInflightRequests() {
        this.cleanupFinishedOperations();
        return !this.pendingOperationsWithSize.isEmpty();
    }

    synchronized long getHeapSize() {
        return this.currentWriteBufferSize;
    }

    public <T> FutureCallback<T> addCallback(ListenableFuture<T> future, final Long id) {
        FutureCallback callback = new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                HeapSizeManager.this.markCanBeCompleted(id);
            }

            @Override
            public void onFailure(Throwable t) {
                HeapSizeManager.this.markCanBeCompleted(id);
            }
        };
        Futures.addCallback(future, callback);
        return callback;
    }

    public void markCanBeCompleted(Long id) {
        this.completedOperationIds.offer(id);
    }
}

