/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.Sleeper;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.AsyncFunction;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.async.RetryableRpc;
import com.google.cloud.bigtable.grpc.scanner.ScanRetriesExhaustedException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryingRpcFunction<RequestT, ResponseT>
implements AsyncFunction<StatusRuntimeException, ResponseT> {
    protected final Log LOG = LogFactory.getLog(RetryingRpcFunction.class);
    private final RequestT request;
    @VisibleForTesting
    BackOff currentBackoff;
    @VisibleForTesting
    Sleeper sleeper = Sleeper.DEFAULT;
    private final RetryableRpc<RequestT, ResponseT> retryableRpc;
    private final RetryOptions retryOptions;

    public static <RequestT, ResponseT> RetryingRpcFunction<RequestT, ResponseT> create(RetryOptions retryOptions, RequestT request, RetryableRpc<RequestT, ResponseT> retryableRpc) {
        return new RetryingRpcFunction<RequestT, ResponseT>(retryOptions, request, retryableRpc);
    }

    private RetryingRpcFunction(RetryOptions retryOptions, RequestT request, RetryableRpc<RequestT, ResponseT> retryableRpc) {
        this.retryOptions = retryOptions;
        this.request = request;
        this.retryableRpc = retryableRpc;
    }

    @Override
    public ListenableFuture<ResponseT> apply(StatusRuntimeException statusException) throws Exception {
        Status.Code code = statusException.getStatus().getCode();
        if (this.retryOptions.isRetryableRead(code)) {
            return this.backOffAndRetry(statusException);
        }
        return Futures.immediateFailedCheckedFuture(statusException);
    }

    private ListenableFuture<ResponseT> backOffAndRetry(StatusRuntimeException cause) throws IOException, ScanRetriesExhaustedException {
        long nextBackOff;
        if (this.currentBackoff == null) {
            this.currentBackoff = this.retryOptions.createBackoff();
        }
        if ((nextBackOff = this.currentBackoff.nextBackOffMillis()) == -1L) {
            throw new ScanRetriesExhaustedException("Exhausted streaming retries.", cause);
        }
        this.sleep(nextBackOff);
        return this.retryableRpc.call(this.request);
    }

    private void sleep(long millis) throws IOException {
        try {
            this.sleeper.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while sleeping for resume", e);
        }
    }
}

