/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class ChannelPool
extends Channel {
    protected static final Logger log = Logger.getLogger(ChannelPool.class.getName());
    private final AtomicReference<ImmutableList<Channel>> channels = new AtomicReference();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final ImmutableList<HeaderInterceptor> headerInterceptors;
    private final AtomicInteger totalSize;
    private final ChannelFactory factory;
    private final String authority;

    public ChannelPool(List<HeaderInterceptor> headerInterceptors, ChannelFactory factory) throws IOException {
        Channel channel = factory.create();
        this.channels.set(ImmutableList.of(channel));
        this.authority = channel.authority();
        this.totalSize = new AtomicInteger(1);
        this.factory = factory;
        this.headerInterceptors = headerInterceptors == null ? ImmutableList.of() : ImmutableList.copyOf(headerInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureChannelCount(int capacity) throws IOException {
        if (this.totalSize.get() < capacity) {
            ChannelPool channelPool = this;
            synchronized (channelPool) {
                if (this.totalSize.get() < capacity) {
                    ArrayList<Channel> newChannelList = new ArrayList<Channel>((Collection)this.channels.get());
                    while (newChannelList.size() < capacity) {
                        newChannelList.add(this.factory.create());
                    }
                    this.setChannels(newChannelList);
                    this.totalSize.set(capacity);
                }
            }
        }
    }

    private Channel getNextChannel() {
        int currentRequestNum = this.requestCount.getAndIncrement();
        ImmutableList<Channel> channelsList = this.channels.get();
        int index = Math.abs(currentRequestNum % channelsList.size());
        return (Channel)channelsList.get(index);
    }

    @Override
    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        return this.createWrappedCall(methodDescriptor, callOptions, this.getNextChannel());
    }

    private <ReqT, RespT> ClientCall<ReqT, RespT> createWrappedCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall<ReqT, RespT> delegate = channel.newCall(methodDescriptor, callOptions);
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(delegate){

            @Override
            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                for (HeaderInterceptor interceptor : ChannelPool.this.headerInterceptors) {
                    interceptor.updateHeaders(headers);
                }
                this.delegate().start(responseListener, headers);
            }
        };
    }

    private void setChannels(List<Channel> newChannelList) {
        this.channels.set(ImmutableList.copyOf(newChannelList));
    }

    public int size() {
        return this.totalSize.get();
    }

    public int availbleSize() {
        return this.channels.get().size();
    }

    public static interface ChannelFactory {
        public Channel create() throws IOException;
    }
}

