/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.stub.ClientCalls;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.cloud.bigtable.grpc.async.AsyncUnaryOperationObserver;
import java.util.Iterator;

public interface ClientCallService {
    public static final ClientCallService DEFAULT = new ClientCallService(){

        @Override
        public <ReqT, RespT> void asyncServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT request, StreamObserver<RespT> observer) {
            ClientCalls.asyncServerStreamingCall(call, request, observer);
        }

        @Override
        public <ReqT, RespT> void asyncServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT request, ClientCall.Listener<RespT> listener) {
            call.start(listener, new Metadata());
            call.request(1);
            try {
                call.sendMessage(request);
                call.halfClose();
            }
            catch (Throwable t) {
                call.cancel();
                throw Throwables.propagate(t);
            }
        }

        @Override
        public <ReqT, RespT> Iterator<RespT> blockingServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT request) {
            return ClientCalls.blockingServerStreamingCall(call, request);
        }

        @Override
        public <ReqT, RespT> RespT blockingUnaryCall(ClientCall<ReqT, RespT> call, ReqT request) {
            return ClientCalls.blockingUnaryCall(call, request);
        }

        @Override
        public <ReqT, RespT> ListenableFuture<RespT> listenableAsyncCall(ClientCall<ReqT, RespT> call, ReqT request) {
            AsyncUnaryOperationObserver observer = new AsyncUnaryOperationObserver();
            ClientCalls.asyncUnaryCall(call, request, observer);
            return observer.getCompletionFuture();
        }
    };

    public <ReqT, RespT> void asyncServerStreamingCall(ClientCall<ReqT, RespT> var1, ReqT var2, StreamObserver<RespT> var3);

    public <ReqT, RespT> void asyncServerStreamingCall(ClientCall<ReqT, RespT> var1, ReqT var2, ClientCall.Listener<RespT> var3);

    public <ReqT, RespT> Iterator<RespT> blockingServerStreamingCall(ClientCall<ReqT, RespT> var1, ReqT var2);

    public <ReqT, RespT> RespT blockingUnaryCall(ClientCall<ReqT, RespT> var1, ReqT var2);

    public <ReqT, RespT> ListenableFuture<RespT> listenableAsyncCall(ClientCall<ReqT, RespT> var1, ReqT var2);
}

