/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Credentials;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.config.CredentialFactory;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import com.google.cloud.bigtable.grpc.io.RefreshingOAuth2CredentialsInterceptor;
import com.google.cloud.bigtable.util.ThreadPoolUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CredentialInterceptorCache {
    private static CredentialInterceptorCache instance = new CredentialInterceptorCache();
    private final ExecutorService executor = Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("Credentials-Refresh"));
    private HeaderInterceptor defaultCredentialInterceptor;

    public static CredentialInterceptorCache getInstance() {
        return instance;
    }

    private CredentialInterceptorCache() {
    }

    public synchronized HeaderInterceptor getCredentialsInterceptor(CredentialOptions credentialOptions, RetryOptions retryOptions) throws IOException, GeneralSecurityException {
        boolean isDefaultCredentials;
        boolean bl = isDefaultCredentials = credentialOptions.getCredentialType() == CredentialOptions.CredentialType.DefaultCredentials;
        if (isDefaultCredentials && this.defaultCredentialInterceptor != null) {
            return this.defaultCredentialInterceptor;
        }
        Credentials credentials = CredentialFactory.getCredentials(credentialOptions);
        if (credentials == null) {
            return null;
        }
        Preconditions.checkState(credentials instanceof OAuth2Credentials, String.format("Credentials must be an instance of OAuth2Credentials, but got %s.", credentials.getClass().getName()));
        RefreshingOAuth2CredentialsInterceptor oauth2Interceptor = new RefreshingOAuth2CredentialsInterceptor(this.executor, (OAuth2Credentials)credentials, retryOptions);
        oauth2Interceptor.asyncRefresh();
        if (isDefaultCredentials) {
            this.defaultCredentialInterceptor = oauth2Interceptor;
        }
        return oauth2Interceptor;
    }
}

