/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReconnectingChannel
extends Channel
implements Closeable {
    protected static final Logger log = Logger.getLogger(ReconnectingChannel.class.getName());
    public static final long CHANNEL_TERMINATE_WAIT_MS = 500L;
    public static final long ACTIVE_REQUEST_START_WAIT_MS = 10L;
    protected final ScheduledExecutorService refreshExecutor;
    private final long maxRefreshMs;
    private final Factory factory;
    private final String authority;
    private ChannelWrapper delegate;

    public ReconnectingChannel(long maxRefreshMs, Factory connectionFactory) throws IOException {
        this(maxRefreshMs, connectionFactory, Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("reconnection-async-close-%s").setDaemon(true).build()));
    }

    @VisibleForTesting
    ReconnectingChannel(long maxRefreshMs, Factory connectionFactory, ScheduledExecutorService executorService) throws IOException {
        Preconditions.checkArgument(maxRefreshMs >= 0L, "maxRefreshMs cannot be less than 0.");
        this.maxRefreshMs = maxRefreshMs;
        this.factory = connectionFactory;
        this.delegate = new ChannelWrapper(this.factory);
        this.authority = this.delegate.channel.authority();
        this.refreshExecutor = executorService;
        if (maxRefreshMs > 0L) {
            double randomizedPercentage = 1.0 - 0.05 * Math.random();
            long delay = (long)((double)this.maxRefreshMs * randomizedPercentage);
            Runnable refreshRunanable = new Runnable(){

                @Override
                public void run() {
                    ChannelWrapper oldDelegate = ReconnectingChannel.this.delegate;
                    try {
                        ReconnectingChannel.this.setDelegate(new ChannelWrapper(ReconnectingChannel.this.factory));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Channel cannot create a new delegate", e);
                    }
                    if (oldDelegate != null) {
                        try {
                            oldDelegate.close();
                        }
                        catch (IOException e) {
                            log.log(Level.INFO, "Could not close a recycled delegate", e);
                        }
                    }
                }
            };
            this.refreshExecutor.scheduleAtFixedRate(refreshRunanable, delay, delay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return new DelayingCall<RequestT, ResponseT>(methodDescriptor, callOptions);
    }

    @Override
    public void close() throws IOException {
        ChannelWrapper toClose = this.getDelegateForClose();
        if (toClose != null) {
            toClose.close();
        }
        this.refreshExecutor.shutdown();
        while (!this.refreshExecutor.isTerminated()) {
            try {
                this.refreshExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
    }

    private synchronized ChannelWrapper getDelegateForRequest() {
        Preconditions.checkState(this.delegate != null, "Channel is closed");
        this.delegate.addActiveRequest();
        return this.delegate;
    }

    private synchronized ChannelWrapper getDelegateForClose() {
        ChannelWrapper toClose = this.delegate;
        this.delegate = null;
        return toClose;
    }

    private synchronized void setDelegate(ChannelWrapper newDelegate) {
        this.delegate = newDelegate;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    private class DelayingCall<RequestT, ResponseT>
    extends ClientCall<RequestT, ResponseT> {
        final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
        final CallOptions callOptions;
        ClientCall<RequestT, ResponseT> callDelegate = null;

        public DelayingCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            this.methodDescriptor = methodDescriptor;
            this.callOptions = callOptions;
        }

        @Override
        public void start(ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
            Preconditions.checkState(this.callDelegate == null, "Call cannot be restarted.");
            this.callDelegate = ReconnectingChannel.this.getDelegateForRequest().start(this.methodDescriptor, this.callOptions, responseListener, headers);
        }

        @Override
        public void request(int numMessages) {
            Preconditions.checkState(this.callDelegate != null, "Not started");
            this.callDelegate.request(numMessages);
        }

        @Override
        public void cancel() {
            if (this.callDelegate != null) {
                this.callDelegate.cancel();
            }
        }

        @Override
        public void halfClose() {
            Preconditions.checkState(this.callDelegate != null, "Not started");
            this.callDelegate.halfClose();
        }

        @Override
        public void sendMessage(RequestT message) {
            Preconditions.checkState(this.callDelegate != null, "Not started");
            this.callDelegate.sendMessage(message);
        }
    }

    private static class ChannelWrapper {
        final Factory factory;
        final Channel channel;
        final AtomicInteger activeRequests = new AtomicInteger();
        final AtomicBoolean isClosing = new AtomicBoolean(false);

        public ChannelWrapper(Factory factory) throws IOException {
            this.factory = factory;
            this.channel = factory.createChannel();
        }

        void addActiveRequest() {
            this.activeRequests.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void completeActiveRequest() {
            int count = this.activeRequests.decrementAndGet();
            if (count == 0 && this.isClosing.get()) {
                ChannelWrapper channelWrapper = this;
                synchronized (channelWrapper) {
                    this.notify();
                }
            }
        }

        synchronized void close() throws IOException {
            this.isClosing.set(true);
            try {
                while (this.activeRequests.get() > 0) {
                    this.wait(10L);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
            this.factory.createClosable(this.channel).close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <RequestT, ResponseT> ClientCall<RequestT, ResponseT> start(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions, ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
            ClientCall<RequestT, ResponseT> callDelegate = null;
            try {
                callDelegate = this.channel.newCall(methodDescriptor, callOptions);
                callDelegate.start(responseListener, headers);
            }
            finally {
                this.completeActiveRequest();
            }
            return callDelegate;
        }
    }

    public static interface Factory {
        public Channel createChannel() throws IOException;

        public Closeable createClosable(Channel var1);
    }
}

