/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.cloud.bigtable.grpc.io.RetryingCall;

class RetryListener<RequestT, ResponseT>
extends ClientCall.Listener<ResponseT> {
    private final RetryingCall<RequestT, ResponseT> retryingCall;
    private final RequestT payload;
    private final Metadata requestHeaders;
    private final boolean isRetriableCall;
    private final ClientCall.Listener<ResponseT> delegate;
    private boolean stateSignalledToListener = false;

    public RetryListener(RetryingCall<RequestT, ResponseT> call, RequestT payload, Metadata requestHeaders, boolean isRetriableCall, ClientCall.Listener<ResponseT> delegate) {
        this.retryingCall = call;
        this.delegate = delegate;
        this.payload = payload;
        this.requestHeaders = requestHeaders;
        this.isRetriableCall = isRetriableCall;
    }

    @Override
    public void onMessage(ResponseT message) {
        this.stateSignalledToListener = true;
        this.delegate.onMessage(message);
    }

    @Override
    public void onHeaders(Metadata headers) {
        this.stateSignalledToListener = true;
        this.delegate.onHeaders(headers);
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        if (RetryListener.isRetriableStatus(status.getCode()) && this.isRetriableCall && !this.stateSignalledToListener && this.retryingCall.retryCallAfterBackoff(this.payload, this.requestHeaders, this)) {
            return;
        }
        this.delegate.onClose(status, trailers);
    }

    @VisibleForTesting
    static boolean isRetriableStatus(Status.Code code) {
        switch (code) {
            case INTERNAL: 
            case UNAVAILABLE: {
                return true;
            }
        }
        return false;
    }
}

