/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.io.RetryListener;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RetryingCall<RequestT, ResponseT>
extends ClientCall<RequestT, ResponseT> {
    private final Channel channel;
    private final MethodDescriptor<RequestT, ResponseT> method;
    private final CallOptions callOptions;
    private final RetryOptions retryOptions;
    private BackOff backOff;
    private final ScheduledExecutorService scheduledExecutorService;
    private ClientCall.Listener<ResponseT> listener;
    private Metadata headers;
    private RequestT message;
    private boolean payloadIsRetriable = true;
    private final SettableFuture<Void> cancelled = SettableFuture.create();

    public RetryingCall(Channel channel, MethodDescriptor<RequestT, ResponseT> method, CallOptions callOptions, ScheduledExecutorService scheduledExecutorService, RetryOptions retryOptions) {
        this.channel = channel;
        this.method = method;
        this.callOptions = callOptions;
        this.scheduledExecutorService = scheduledExecutorService;
        this.retryOptions = retryOptions;
    }

    @Override
    public void start(ClientCall.Listener<ResponseT> listener, Metadata headers) {
        Preconditions.checkState(this.listener == null, "start should not be invoked more than once for unary calls.");
        this.listener = new RetryListener<RequestT, ResponseT>(this, this.message, headers, this.payloadIsRetriable, listener);
        this.headers = headers;
    }

    @Override
    public void request(int numMessages) {
    }

    @Override
    public void cancel() {
        this.cancelled.set(null);
    }

    @Override
    public void sendMessage(RequestT message) {
        Preconditions.checkState(this.message == null, "sendPayload should not be invoked more than once for unary calls.");
        this.message = message;
    }

    @Override
    public void halfClose() {
        this.retryCall(this.message, this.headers, this.listener);
    }

    private void retryCall(RequestT message, Metadata requestHeaders, ClientCall.Listener<ResponseT> listener) {
        final ClientCall<RequestT, ResponseT> delegate = this.channel.newCall(this.method, this.callOptions);
        delegate.start(listener, requestHeaders);
        delegate.request(1);
        this.cancelled.addListener(new Runnable(){

            @Override
            public void run() {
                delegate.cancel();
            }
        }, MoreExecutors.directExecutor());
        delegate.sendMessage(message);
        delegate.halfClose();
    }

    @VisibleForTesting
    synchronized boolean retryCallAfterBackoff(final RequestT payload, final Metadata requestHeaders, final ClientCall.Listener<ResponseT> listener) {
        long sleepTimeout = -1L;
        if (this.backOff == null) {
            this.backOff = this.retryOptions.createBackoff();
        }
        try {
            sleepTimeout = this.backOff.nextBackOffMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sleepTimeout != -1L) {
            this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        RetryingCall.this.retryCall(payload, requestHeaders, listener);
                    }
                    catch (RuntimeException e) {
                        Metadata trailers = new Metadata();
                        listener.onClose(Status.fromThrowable(e), trailers);
                    }
                }
            }, sleepTimeout, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public boolean isReady() {
        return true;
    }
}

