/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.cloud.bigtable.grpc.io.HeaderInterceptor;

public class UserAgentInterceptor
implements HeaderInterceptor {
    private static final Metadata.Key<String> USER_AGENT_KEY = Metadata.Key.of("User-Agent", Metadata.ASCII_STRING_MARSHALLER);
    private final String userAgent;

    public UserAgentInterceptor(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void updateHeaders(Metadata headers) throws Exception {
        String userAgents = headers.get(USER_AGENT_KEY);
        userAgents = userAgents == null ? this.userAgent : userAgents + " " + this.userAgent;
        headers.put(USER_AGENT_KEY, userAgents);
    }
}

