/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.cloud.bigtable.grpc.scanner.ResultQueueEntry;
import com.google.cloud.bigtable.grpc.scanner.RowMerger;
import com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ResponseQueueReader {
    private final BlockingQueue<ResultQueueEntry<ReadRowsResponse>> resultQueue;
    private final int readPartialRowTimeoutMillis;
    private boolean lastResponseProcessed = false;
    private AtomicBoolean completionMarkerFound = new AtomicBoolean(false);
    private final int capacityCap;
    private final int batchRequestSize;
    private AtomicInteger outstandingRequestCount;
    private final ClientCall<?, ReadRowsResponse> call;

    public ResponseQueueReader(int readPartialRowTimeoutMillis, int capacityCap, int outstandingRequestCount, int batchRequestSize, ClientCall<?, ReadRowsResponse> call) {
        this.resultQueue = new LinkedBlockingQueue<ResultQueueEntry<ReadRowsResponse>>();
        this.readPartialRowTimeoutMillis = readPartialRowTimeoutMillis;
        this.capacityCap = capacityCap;
        this.outstandingRequestCount = new AtomicInteger(outstandingRequestCount);
        this.batchRequestSize = batchRequestSize;
        this.call = call;
    }

    public synchronized Row getNextMergedRow() throws IOException {
        RowMerger builder = null;
        while (!this.lastResponseProcessed) {
            ResultQueueEntry<ReadRowsResponse> queueEntry = this.getNext();
            if (queueEntry.isCompletionMarker()) {
                this.lastResponseProcessed = true;
                break;
            }
            ReadRowsResponse partialRow = queueEntry.getResponseOrThrow();
            if (builder == null) {
                builder = new RowMerger();
            }
            builder.addPartialRow(partialRow);
            if (!builder.isRowCommitted()) continue;
            Row builtRow = builder.buildRow();
            if (builtRow == null) {
                builder = null;
                continue;
            }
            return builtRow;
        }
        Preconditions.checkState(builder == null, "End of stream marker encountered while merging a row.");
        Preconditions.checkState(this.lastResponseProcessed, "Should only exit merge loop with by returning a complete Row or hitting end of stream.");
        return null;
    }

    private ResultQueueEntry<ReadRowsResponse> getNext() throws IOException {
        ResultQueueEntry<ReadRowsResponse> queueEntry;
        if (!this.completionMarkerFound.get() && this.moreCanBeRequested()) {
            this.call.request(this.batchRequestSize);
            this.outstandingRequestCount.addAndGet(this.batchRequestSize);
        }
        try {
            queueEntry = this.resultQueue.poll(this.readPartialRowTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for next result", e);
        }
        if (queueEntry == null) {
            throw new ScanTimeoutException("Timeout while merging responses.");
        }
        return queueEntry;
    }

    private boolean moreCanBeRequested() {
        return this.outstandingRequestCount.get() + this.resultQueue.size() <= this.capacityCap - this.batchRequestSize;
    }

    public int available() {
        return this.resultQueue.size();
    }

    public void add(ResultQueueEntry<ReadRowsResponse> entry) throws InterruptedException {
        if (entry.isCompletionMarker()) {
            this.completionMarkerFound.set(true);
        }
        this.outstandingRequestCount.decrementAndGet();
        this.resultQueue.put(entry);
    }
}

