/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.cloud.bigtable.grpc.io.IOExceptionWithStatus;
import java.io.IOException;

class ResultQueueEntry<T> {
    private static final String EXCEPTION_MESSAGE = "Error in response stream";
    protected final Throwable throwable;
    protected final T response;
    protected final boolean isComplete;

    public static <T> ResultQueueEntry<T> newResult(T response) {
        Preconditions.checkArgument(response != null, "Response may not be null");
        return new ResultQueueEntry<T>(null, response, false);
    }

    public static <T> ResultQueueEntry<T> newThrowable(Throwable throwable) {
        Preconditions.checkArgument(throwable != null, "Throwable may not be null");
        return new ResultQueueEntry<Object>(throwable, null, false);
    }

    public static <T> ResultQueueEntry<T> newCompletionMarker() {
        return new ResultQueueEntry<Object>(null, null, true);
    }

    protected ResultQueueEntry(Throwable throwable, T response, boolean isCompletionMarker) {
        this.throwable = throwable;
        this.response = response;
        this.isComplete = isCompletionMarker;
    }

    public boolean isCompletionMarker() {
        return this.isComplete;
    }

    public T getResponseOrThrow() throws IOException {
        if (this.throwable != null) {
            if (this.throwable instanceof StatusRuntimeException) {
                throw new IOExceptionWithStatus(EXCEPTION_MESSAGE, (StatusRuntimeException)this.throwable);
            }
            if (this.throwable instanceof UncheckedExecutionException && this.throwable.getCause() instanceof StatusRuntimeException) {
                throw new IOExceptionWithStatus(EXCEPTION_MESSAGE, (StatusRuntimeException)this.throwable.getCause());
            }
            throw new IOException(EXCEPTION_MESSAGE, this.throwable);
        }
        if (this.isComplete) {
            throw new IOException("Attempt to interpret a result stream completion marker as a result");
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResultQueueEntry) || obj == null) {
            return false;
        }
        ResultQueueEntry other = (ResultQueueEntry)obj;
        return Objects.equal(this.throwable, other.throwable) && Objects.equal(this.response, other.response) && Objects.equal(this.isComplete, other.isComplete);
    }
}

