/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.Sleeper;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.Row;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.io.IOExceptionWithStatus;
import com.google.cloud.bigtable.grpc.scanner.AbstractBigtableResultScanner;
import com.google.cloud.bigtable.grpc.scanner.BigtableResultScannerFactory;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.grpc.scanner.ScanRetriesExhaustedException;
import com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import java.io.IOException;

public class ResumingStreamingResultScanner
extends AbstractBigtableResultScanner {
    private static final Logger LOG = new Logger(ResumingStreamingResultScanner.class);
    private static final ByteString NEXT_ROW_SUFFIX = ByteString.copyFrom(new byte[]{0});
    private final BigtableResultScannerFactory scannerFactory;
    private final ReadRowsRequest originalRequest;
    private final RetryOptions retryOptions;
    private BackOff currentBackoff;
    private ResultScanner<Row> currentDelegate;
    private ByteString lastRowKey = null;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private long rowCount = 0L;
    private final Logger logger;

    static ByteString nextRowKey(ByteString previous) {
        return previous.concat(NEXT_ROW_SUFFIX);
    }

    public ResumingStreamingResultScanner(RetryOptions retryOptions, ReadRowsRequest originalRequest, BigtableResultScannerFactory scannerFactory) {
        this(retryOptions, originalRequest, scannerFactory, LOG);
    }

    @VisibleForTesting
    ResumingStreamingResultScanner(RetryOptions retryOptions, ReadRowsRequest originalRequest, BigtableResultScannerFactory scannerFactory, Logger logger) {
        com.google.bigtable.repackaged.com.google.api.client.util.Preconditions.checkArgument(!originalRequest.getAllowRowInterleaving(), "Row interleaving is not supported when using resumable streams");
        this.originalRequest = originalRequest;
        this.scannerFactory = scannerFactory;
        this.currentDelegate = scannerFactory.createScanner(originalRequest);
        this.retryOptions = retryOptions;
        this.logger = logger;
    }

    @Override
    public Row next() throws IOException {
        while (true) {
            try {
                Row result = this.currentDelegate.next();
                if (result != null) {
                    this.lastRowKey = result.getKey();
                    ++this.rowCount;
                    this.currentBackoff = null;
                }
                return result;
            }
            catch (ScanTimeoutException rte) {
                this.logger.info("The client could not get a response in %d ms. Retrying the scan.", this.retryOptions.getReadPartialRowTimeoutMillis());
                this.backOffAndRetry(rte);
                continue;
            }
            catch (IOExceptionWithStatus ioe) {
                Status.Code code = ioe.getStatus().getCode();
                if (this.retryOptions.isRetryableRead(code)) {
                    this.logger.info("Reissuing scan after receiving error with status: %s.", code.name());
                    this.backOffAndRetry(ioe);
                    continue;
                }
                throw ioe;
            }
            break;
        }
    }

    @Override
    public int available() {
        return this.currentDelegate.available();
    }

    private void backOffAndRetry(IOException cause) throws IOException, ScanRetriesExhaustedException {
        long nextBackOff;
        if (this.currentBackoff == null) {
            this.currentBackoff = this.retryOptions.createBackoff();
        }
        if ((nextBackOff = this.currentBackoff.nextBackOffMillis()) == -1L) {
            throw new ScanRetriesExhaustedException("Exhausted streaming retries.", cause);
        }
        this.sleep(nextBackOff);
        this.reissueRequest();
    }

    @Override
    public void close() throws IOException {
        this.currentDelegate.close();
    }

    private void reissueRequest() {
        long numRowsLimit;
        try {
            this.currentDelegate.close();
        }
        catch (IOException ioe) {
            this.logger.warn("Error closing scanner before reissuing request: ", ioe, new Object[0]);
        }
        ReadRowsRequest.Builder newRequest = this.originalRequest.toBuilder();
        if (this.lastRowKey != null) {
            newRequest.getRowRangeBuilder().setStartKey(ResumingStreamingResultScanner.nextRowKey(this.lastRowKey));
        }
        if ((numRowsLimit = newRequest.getNumRowsLimit()) > 0L) {
            Preconditions.checkArgument((numRowsLimit -= this.rowCount) > 0L, "The remaining number of rows must be greater than 0.");
            newRequest.setNumRowsLimit(numRowsLimit);
        }
        this.currentDelegate = this.scannerFactory.createScanner(newRequest.build());
    }

    private void sleep(long millis) throws IOException {
        try {
            this.sleeper.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while sleeping for resume", e);
        }
    }
}

