/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.Family;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class RowMerger {
    private final Map<String, Family.Builder> familyMap = new HashMap<String, Family.Builder>();
    private boolean committed = false;
    private ByteString currentRowKey;

    public static Row readNextRow(Iterator<ReadRowsResponse> responseIterator) {
        do {
            Preconditions.checkState(responseIterator.hasNext(), "End of stream marker encountered while merging a row.");
            RowMerger rowMerger = new RowMerger();
            while (responseIterator.hasNext() && !rowMerger.isRowCommitted()) {
                rowMerger.addPartialRow(responseIterator.next());
            }
            Preconditions.checkState(rowMerger.isRowCommitted(), "End of stream marker encountered while merging a row.");
            Row builtRow = rowMerger.buildRow();
            if (builtRow == null) continue;
            return builtRow;
        } while (responseIterator.hasNext());
        return null;
    }

    public void addPartialRow(ReadRowsResponse partialRow) {
        Preconditions.checkState(this.currentRowKey == null || this.currentRowKey.equals(partialRow.getRowKey()), "Interleaved ReadRowResponse messages are not supported.");
        if (this.currentRowKey == null) {
            this.currentRowKey = partialRow.getRowKey();
        }
        block5: for (ReadRowsResponse.Chunk chunk : partialRow.getChunksList()) {
            Preconditions.checkState(!this.committed, "Encountered chunk after row commit.");
            switch (chunk.getChunkCase()) {
                case ROW_CONTENTS: {
                    this.merge(this.familyMap, chunk.getRowContents());
                    continue block5;
                }
                case RESET_ROW: {
                    this.familyMap.clear();
                    continue block5;
                }
                case COMMIT_ROW: {
                    this.committed = true;
                    continue block5;
                }
            }
            throw new IllegalStateException(String.format("Unknown ChunkCase encountered %s", chunk.getChunkCase()));
        }
    }

    public boolean isRowCommitted() {
        return this.committed;
    }

    @Nullable
    public Row buildRow() {
        Preconditions.checkState(this.committed, "Cannot build a Row object if we have not yet encountered a COMMIT_ROW chunk.");
        if (this.familyMap.isEmpty()) {
            return null;
        }
        Row.Builder currentRowBuilder = Row.newBuilder();
        currentRowBuilder.setKey(this.currentRowKey);
        for (Family.Builder builder : this.familyMap.values()) {
            currentRowBuilder.addFamilies(builder.build());
        }
        return currentRowBuilder.build();
    }

    private void merge(Map<String, Family.Builder> familyBuilderMap, Family newRowContents) {
        String familyName = newRowContents.getName();
        Family.Builder familyBuilder = familyBuilderMap.get(familyName);
        if (familyBuilder == null) {
            familyBuilder = Family.newBuilder().setName(familyName);
            familyBuilderMap.put(familyName, familyBuilder);
        }
        familyBuilder.addAllColumns(newRowContents.getColumnsList());
    }
}

