/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.cloud.bigtable.grpc.io.CancellationToken;
import com.google.cloud.bigtable.grpc.scanner.AbstractBigtableResultScanner;
import com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.cloud.bigtable.grpc.scanner.ResultQueueEntry;
import java.io.IOException;

public class StreamingBigtableResultScanner
extends AbstractBigtableResultScanner {
    private final CancellationToken cancellationToken;
    private final ResponseQueueReader responseQueueReader;

    public StreamingBigtableResultScanner(ResponseQueueReader responseQueueReader, CancellationToken cancellationToken) {
        Preconditions.checkArgument(cancellationToken != null, "cancellationToken cannot be null");
        this.cancellationToken = cancellationToken;
        this.responseQueueReader = responseQueueReader;
    }

    private void add(ResultQueueEntry<ReadRowsResponse> entry) {
        try {
            this.responseQueueReader.add(entry);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    public void addResult(ReadRowsResponse response) {
        this.add(ResultQueueEntry.newResult(response));
    }

    public void setError(Throwable error) {
        this.add(ResultQueueEntry.newThrowable(error));
    }

    public void complete() {
        this.add(ResultQueueEntry.newCompletionMarker());
    }

    @Override
    public Row next() throws IOException {
        return this.responseQueueReader.getNextMergedRow();
    }

    @Override
    public int available() {
        return this.responseQueueReader.available();
    }

    @Override
    public void close() throws IOException {
        this.cancellationToken.cancel();
    }
}

