/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.bigtable.v1.Row;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.coprocessor.Batch;

public class BatchExecutor {
    protected static final Logger LOG = new Logger(BatchExecutor.class);
    public static final byte[] NO_REGION = new byte[0];
    private static final Function<List<Row>, Row> ROWS_TO_ROW_CONVERTER = new Function<List<Row>, Row>(){

        @Override
        public Row apply(List<Row> rows) {
            if (rows.isEmpty()) {
                return null;
            }
            return rows.get(0);
        }
    };
    protected final AsyncExecutor asyncExecutor;
    protected final BigtableOptions options;
    protected final ListeningExecutorService service;
    protected final HBaseRequestAdapter requestAdapter;

    public BatchExecutor(AsyncExecutor asyncExecutor, BigtableOptions options, ListeningExecutorService service, HBaseRequestAdapter requestAdapter) {
        this.asyncExecutor = asyncExecutor;
        this.options = options;
        this.service = service;
        this.requestAdapter = requestAdapter;
    }

    private <R extends org.apache.hadoop.hbase.client.Row, T> ListenableFuture<Result> issueAsyncRowRequest(org.apache.hadoop.hbase.client.Row row, Batch.Callback<T> callback, Object[] results, int index) {
        LOG.trace("issueRowRequest(Row, Batch.Callback, Object[], index", new Object[0]);
        SettableFuture<Result> resultFuture = SettableFuture.create();
        RpcResultFutureCallback<T> futureCallback = new RpcResultFutureCallback<T>(row, callback, index, results, resultFuture);
        results[index] = null;
        if (this.service.isShutdown()) {
            ListenableFuture failFuture = Futures.immediateFailedFuture(new IOException("Cannot perform batch operations when a connection is closed"));
            Futures.addCallback(failFuture, futureCallback);
        } else {
            ListenableFuture<? extends GeneratedMessage> future = this.issueAsyncRequest(row);
            Futures.addCallback(future, futureCallback, this.service);
        }
        return resultFuture;
    }

    private ListenableFuture<? extends GeneratedMessage> issueAsyncRequest(org.apache.hadoop.hbase.client.Row row) {
        try {
            if (row instanceof Get) {
                return Futures.transform(this.asyncExecutor.readRowsAsync(this.requestAdapter.adapt((Get)row)), ROWS_TO_ROW_CONVERTER);
            }
            if (row instanceof Put) {
                return this.asyncExecutor.mutateRowAsync(this.requestAdapter.adapt((Put)row));
            }
            if (row instanceof Delete) {
                return this.asyncExecutor.mutateRowAsync(this.requestAdapter.adapt((Delete)row));
            }
            if (row instanceof Append) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.requestAdapter.adapt((Append)row));
            }
            if (row instanceof Increment) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.requestAdapter.adapt((Increment)row));
            }
            if (row instanceof RowMutations) {
                return this.asyncExecutor.mutateRowAsync(this.requestAdapter.adapt((RowMutations)row));
            }
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture(e);
        }
        LOG.error("Encountered unknown action type %s", row.getClass());
        return Futures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown action type: " + row.getClass()));
    }

    public void batch(List<? extends org.apache.hadoop.hbase.client.Row> actions, @Nullable Object[] results) throws IOException, InterruptedException {
        if (results == null) {
            results = new Object[actions.size()];
        }
        Preconditions.checkArgument(results.length == actions.size(), "Result array must have same dimensions as actions list.");
        List<ListenableFuture<?>> resultFutures = this.issueAsyncRowRequests(actions, results, null);
        try {
            Futures.successfulAsList(resultFutures).get();
            ArrayList<Throwable> problems = new ArrayList<Throwable>();
            ArrayList<org.apache.hadoop.hbase.client.Row> problemActions = new ArrayList<org.apache.hadoop.hbase.client.Row>();
            ArrayList<String> hosts = new ArrayList<String>();
            for (int i = 0; i < resultFutures.size(); ++i) {
                try {
                    resultFutures.get(i).get();
                    continue;
                }
                catch (ExecutionException e) {
                    problemActions.add(actions.get(i));
                    problems.add(e.getCause());
                    hosts.add(this.options.getDataHost().toString());
                }
            }
            if (problems.size() > 0) {
                throw new RetriesExhaustedWithDetailsException(problems, problemActions, hosts);
            }
        }
        catch (ExecutionException e) {
            LOG.error("Encountered exception in batch(List<>, Object[]).", e, new Object[0]);
            throw new IOException("Batch error", e);
        }
    }

    private <R> List<ListenableFuture<?>> issueAsyncRowRequests(List<? extends org.apache.hadoop.hbase.client.Row> actions, Object[] results, Batch.Callback<R> callback) {
        ArrayList resultFutures = new ArrayList(actions.size());
        for (int i = 0; i < actions.size(); ++i) {
            resultFutures.add(this.issueAsyncRowRequest(actions.get(i), callback, results, i));
        }
        return resultFutures;
    }

    public Result[] batch(List<? extends org.apache.hadoop.hbase.client.Row> actions) throws IOException {
        try {
            Object[] results = new Result[actions.size()];
            this.batch(actions, results);
            return results;
        }
        catch (InterruptedException e) {
            LOG.error("Encountered exception in batch(List<>).", e, new Object[0]);
            throw new IOException("Batch error", e);
        }
    }

    public <R> void batchCallback(List<? extends org.apache.hadoop.hbase.client.Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Preconditions.checkArgument(results.length == actions.size(), "Result array must be the same length as actions.");
        try {
            Futures.successfulAsList(this.issueAsyncRowRequests(actions, results, callback)).get();
        }
        catch (ExecutionException e) {
            LOG.error("Encountered exception in batchCallback(List<>, Object[], Batch.Callback). ", e, new Object[0]);
            throw new IOException("batchCallback error", e);
        }
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        Result[] getResults = this.batch(gets);
        Boolean[] exists = new Boolean[getResults.length];
        for (int index = 0; index < getResults.length; ++index) {
            exists[index] = !getResults[index].isEmpty();
        }
        return exists;
    }

    static class RpcResultFutureCallback<T>
    implements FutureCallback<GeneratedMessage> {
        private final org.apache.hadoop.hbase.client.Row row;
        private final Batch.Callback<T> callback;
        private final int index;
        private final Object[] resultsArray;
        private final SettableFuture<Result> resultFuture;

        public RpcResultFutureCallback(org.apache.hadoop.hbase.client.Row row, Batch.Callback<T> callback, int index, Object[] resultsArray, SettableFuture<Result> resultFuture) {
            this.row = row;
            this.callback = callback;
            this.index = index;
            this.resultsArray = resultsArray;
            this.resultFuture = resultFuture;
        }

        @Override
        public final void onSuccess(GeneratedMessage message) {
            try {
                Result result = Result.EMPTY_RESULT;
                if (message instanceof Row) {
                    result = Adapters.ROW_ADAPTER.adaptResponse((Row)message);
                }
                this.resultsArray[this.index] = result;
                this.resultFuture.set(result);
                if (this.callback != null) {
                    this.callback.update(NO_REGION, this.row.getRow(), (Object)result);
                }
            }
            catch (Throwable throwable) {
                this.resultFuture.setException(throwable);
            }
        }

        @Override
        public final void onFailure(Throwable throwable) {
            this.resultsArray[this.index] = null;
            this.resultFuture.setException(throwable);
            if (this.callback != null) {
                this.callback.update(NO_REGION, this.row.getRow(), null);
            }
        }
    }
}

