/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.grpc.async.HeapSizeManager;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;

public class BigtableBufferedMutator
implements BufferedMutator {
    protected static final Logger LOG = new Logger(BigtableBufferedMutator.class);
    protected static final long MUTATION_TO_BE_SENT_WAIT_MS = 1000L;
    private final MutationOperation CLOSE_MARKER = new MutationOperation(null, -1L, true);
    private final Configuration configuration;
    private final ReentrantReadWriteLock isClosedLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock closedReadLock = this.isClosedLock.readLock();
    private final ReentrantReadWriteLock.WriteLock closedWriteLock = this.isClosedLock.writeLock();
    private boolean closed = false;
    private final HBaseRequestAdapter adapter;
    private final BufferedMutator.ExceptionListener exceptionListener;
    private final AtomicBoolean hasExceptions = new AtomicBoolean(false);
    private final List<MutationException> globalExceptions = new ArrayList<MutationException>();
    private final String host;
    private final HeapSizeManager heapSizeManager;
    private final AsyncExecutor asyncExecutor;
    private final ExecutorService executorService;
    private final BigtableOptions options;
    private final LinkedBlockingQueue<MutationOperation> mutationsToBeSent = new LinkedBlockingQueue();
    private final AtomicInteger activeMutationWorkers = new AtomicInteger();
    private final Runnable mutationWorker = new Runnable(){

        @Override
        public void run() {
            BigtableBufferedMutator.this.activeMutationWorkers.incrementAndGet();
            try {
                while (!BigtableBufferedMutator.this.executorService.isShutdown()) {
                    try {
                        MutationOperation operation = (MutationOperation)BigtableBufferedMutator.this.mutationsToBeSent.poll(1000L, TimeUnit.MILLISECONDS);
                        if (operation == null) break;
                        if (operation.isCloseMarker) {
                            break;
                        }
                        operation.run();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        LOG.info("Interrupted. Shutting down mutationRunnable.", new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        LOG.error("Exception in buffered mutator.", e, new Object[0]);
                    }
                }
            }
            finally {
                BigtableBufferedMutator.this.activeMutationWorkers.decrementAndGet();
            }
        }
    };

    public BigtableBufferedMutator(BigtableDataClient client, HBaseRequestAdapter adapter, Configuration configuration, BigtableOptions options, BufferedMutator.ExceptionListener listener, HeapSizeManager heapSizeManager, ExecutorService asyncRpcExecutorService) {
        this.adapter = adapter;
        this.configuration = configuration;
        this.exceptionListener = listener;
        this.host = options.getDataHost().toString();
        this.asyncExecutor = new AsyncExecutor(client, heapSizeManager);
        LOG.info("Initializing BigtableBufferd Mutator with %d channels, %,d byte heap size and %d concurrent requests.", options.getChannelCount(), heapSizeManager.getMaxHeapSize(), heapSizeManager.getMaxInFlightRpcs());
        this.options = options;
        this.heapSizeManager = heapSizeManager;
        this.executorService = asyncRpcExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAsyncMutators() {
        if (this.executorService != null && this.activeMutationWorkers.get() < this.options.getAsyncMutatorCount()) {
            AtomicInteger atomicInteger = this.activeMutationWorkers;
            synchronized (atomicInteger) {
                for (int i = this.activeMutationWorkers.get(); i < this.options.getAsyncMutatorCount(); ++i) {
                    this.executorService.submit(this.mutationWorker);
                }
            }
        }
    }

    public void close() throws IOException {
        this.closedWriteLock.lock();
        try {
            this.flush();
            int activeWorkerCount = this.activeMutationWorkers.get();
            for (int i = 0; i < activeWorkerCount; ++i) {
                this.mutationsToBeSent.add(this.CLOSE_MARKER);
            }
            this.closed = true;
        }
        finally {
            this.closedWriteLock.unlock();
        }
    }

    public void flush() throws IOException {
        if (!this.mutationsToBeSent.isEmpty()) {
            this.initializeAsyncMutators();
        }
        this.asyncExecutor.flush();
        this.handleExceptions();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TableName getName() {
        return this.adapter.getTableName();
    }

    public long getWriteBufferSize() {
        return this.asyncExecutor.getMaxHeapSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(List<? extends Mutation> mutations) throws IOException {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            this.handleExceptions();
            for (Mutation mutation : mutations) {
                this.offer(mutation);
            }
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    public void mutate(Mutation mutation) throws IOException {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            this.handleExceptions();
            this.offer(mutation);
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    private void offer(Mutation mutation) throws IOException {
        try {
            this.initializeAsyncMutators();
            long operationId = this.heapSizeManager.registerOperationWithHeapSize(mutation.heapSize());
            MutationOperation operation = new MutationOperation(mutation, operationId, false);
            if (this.executorService != null && this.options.getAsyncMutatorCount() > 0) {
                this.mutationsToBeSent.add(operation);
            } else {
                operation.run();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("Interrupted in buffered mutator while mutating row : '" + Bytes.toString((byte[])mutation.getRow()), e);
        }
    }

    private ListenableFuture<? extends GeneratedMessage> issueRequest(Mutation mutation, long operationId) {
        try {
            if (mutation == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("Cannot perform a mutation on a null object."));
            }
            if (mutation instanceof Put) {
                return this.asyncExecutor.mutateRowAsync(this.adapter.adapt((Put)mutation), operationId);
            }
            if (mutation instanceof Delete) {
                return this.asyncExecutor.mutateRowAsync(this.adapter.adapt((Delete)mutation), operationId);
            }
            if (mutation instanceof Increment) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Increment)mutation), operationId);
            }
            if (mutation instanceof Append) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Append)mutation), operationId);
            }
            return Futures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown mutation type: " + mutation.getClass()));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlobalException(Row mutation, Throwable t) {
        List<MutationException> list = this.globalExceptions;
        synchronized (list) {
            this.globalExceptions.add(new MutationException(mutation, t));
            this.hasExceptions.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptions() throws RetriesExhaustedWithDetailsException {
        if (this.hasExceptions.get()) {
            ArrayList<MutationException> mutationExceptions = null;
            List<MutationException> list = this.globalExceptions;
            synchronized (list) {
                this.hasExceptions.set(false);
                if (this.globalExceptions.isEmpty()) {
                    return;
                }
                mutationExceptions = new ArrayList<MutationException>(this.globalExceptions);
                this.globalExceptions.clear();
            }
            ArrayList<Throwable> problems = new ArrayList<Throwable>(mutationExceptions.size());
            ArrayList<String> hostnames = new ArrayList<String>(mutationExceptions.size());
            ArrayList<Row> failedMutations = new ArrayList<Row>(mutationExceptions.size());
            for (MutationException mutationException : mutationExceptions) {
                problems.add(mutationException.throwable);
                failedMutations.add(mutationException.mutation);
                hostnames.add(this.host);
            }
            RetriesExhaustedWithDetailsException exception = new RetriesExhaustedWithDetailsException(problems, failedMutations, hostnames);
            this.exceptionListener.onException(exception, (BufferedMutator)this);
        }
    }

    public boolean hasInflightRequests() {
        return this.asyncExecutor.hasInflightRequests();
    }

    private class ExceptionCallback
    implements FutureCallback<GeneratedMessage> {
        private final Row mutation;

        public ExceptionCallback(Row mutation) {
            this.mutation = mutation;
        }

        @Override
        public void onFailure(Throwable t) {
            BigtableBufferedMutator.this.addGlobalException(this.mutation, t);
        }

        @Override
        public void onSuccess(GeneratedMessage ignored) {
        }
    }

    private class MutationOperation {
        final Mutation mutation;
        final long operationId;
        final boolean isCloseMarker;

        public MutationOperation(Mutation mutation, long operationId, boolean isClosedMarker) {
            this.mutation = mutation;
            this.operationId = operationId;
            this.isCloseMarker = isClosedMarker;
        }

        public void run() {
            ListenableFuture request = BigtableBufferedMutator.this.issueRequest(this.mutation, this.operationId);
            ExceptionCallback callback = new ExceptionCallback((Row)this.mutation);
            Futures.addCallback(request, callback);
        }
    }

    private static class MutationException {
        private final Row mutation;
        private final Throwable throwable;

        MutationException(Row mutation, Throwable throwable) {
            this.mutation = mutation;
            this.throwable = throwable;
        }
    }
}

