/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public class BigtableOptionsFactory {
    protected static final Logger LOG = new Logger(BigtableOptionsFactory.class);
    public static final String BIGTABLE_PORT_KEY = "google.bigtable.endpoint.port";
    public static final String BIGTABLE_CLUSTER_ADMIN_HOST_KEY = "google.bigtable.cluster.admin.endpoint.host";
    public static final String BIGTABLE_TABLE_ADMIN_HOST_KEY = "google.bigtable.admin.endpoint.host";
    public static final String BIGTABLE_HOST_KEY = "google.bigtable.endpoint.host";
    public static final String PROJECT_ID_KEY = "google.bigtable.project.id";
    public static final String CLUSTER_KEY = "google.bigtable.cluster.name";
    public static final String ZONE_KEY = "google.bigtable.zone.name";
    public static final String BIGTABE_USE_SERVICE_ACCOUNTS_KEY = "google.bigtable.auth.service.account.enable";
    public static final boolean BIGTABLE_USE_SERVICE_ACCOUNTS_DEFAULT = true;
    public static final String BIGTABLE_NULL_CREDENTIAL_ENABLE_KEY = "google.bigtable.auth.null.credential.enable";
    public static final boolean BIGTABLE_NULL_CREDENTIAL_ENABLE_DEFAULT = false;
    public static final String BIGTABLE_SERVICE_ACCOUNT_EMAIL_KEY = "google.bigtable.auth.service.account.email";
    public static final String BIGTABLE_SERVICE_ACCOUNT_P12_KEYFILE_LOCATION_KEY = "google.bigtable.auth.service.account.keyfile";
    public static final String BIGTABLE_SERVICE_ACCOUNT_JSON_KEYFILE_LOCATION_KEY = "google.bigtable.auth.json.keyfile";
    public static final String ENABLE_GRPC_RETRIES_KEY = "google.bigtable.grpc.retry.enable";
    public static final String ENABLE_GRPC_RETRY_DEADLINEEXCEEDED_KEY = "google.bigtable.grpc.retry.deadlineexceeded.enable";
    public static final String MAX_ELAPSED_BACKOFF_MILLIS_KEY = "google.bigtable.grpc.retry.max.elapsed.backoff.ms";
    public static final String READ_PARTIAL_ROW_TIMEOUT_MS = "google.bigtable.grpc.read.partial.row.timeout.ms";
    public static final String READ_BUFFER_SIZE = "google.bigtable.grpc.read.streaming.buffer.size";
    public static final String READ_BATCH_SIZE = "google.bigtable.grpc.read.streaming.batch.size";
    public static final String BIGTABLE_DATA_CHANNEL_COUNT_KEY = "google.bigtable.grpc.channel.count";
    public static final String BIGTABLE_CHANNEL_TIMEOUT_MS_KEY = "google.bigtable.grpc.channel.timeout.ms";
    public static final String BIGTABLE_ASYNC_MUTATOR_COUNT_KEY = "google.bigtable.buffered.mutator.async.worker.count";

    public static BigtableOptions fromConfiguration(Configuration configuration) throws IOException {
        BigtableOptions.Builder bigtableOptionsBuilder = new BigtableOptions.Builder();
        bigtableOptionsBuilder.setProjectId(BigtableOptionsFactory.getValue(configuration, PROJECT_ID_KEY, "Project ID"));
        bigtableOptionsBuilder.setZoneId(BigtableOptionsFactory.getValue(configuration, ZONE_KEY, "Zone"));
        bigtableOptionsBuilder.setClusterId(BigtableOptionsFactory.getValue(configuration, CLUSTER_KEY, "Cluster"));
        bigtableOptionsBuilder.setDataHost(BigtableOptionsFactory.getHost(configuration, BIGTABLE_HOST_KEY, "bigtable.googleapis.com", "API Data"));
        bigtableOptionsBuilder.setTableAdminHost(BigtableOptionsFactory.getHost(configuration, BIGTABLE_TABLE_ADMIN_HOST_KEY, "bigtabletableadmin.googleapis.com", "Table Admin"));
        bigtableOptionsBuilder.setClusterAdminHost(BigtableOptionsFactory.getHost(configuration, BIGTABLE_CLUSTER_ADMIN_HOST_KEY, "bigtableclusteradmin.googleapis.com", "Cluster Admin"));
        int port = configuration.getInt(BIGTABLE_PORT_KEY, 443);
        bigtableOptionsBuilder.setPort(port);
        BigtableOptionsFactory.setChannelOptions(bigtableOptionsBuilder, configuration);
        int asyncMutatorCount = configuration.getInt(BIGTABLE_ASYNC_MUTATOR_COUNT_KEY, 2);
        bigtableOptionsBuilder.setAsyncMutatorWorkerCount(asyncMutatorCount);
        return bigtableOptionsBuilder.build();
    }

    private static String getValue(Configuration configuration, String key, String type) {
        String value = configuration.get(key);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(value), String.format("%s must be supplied via %s", type, key));
        LOG.debug("%s %s", type, value);
        return value;
    }

    private static String getHost(Configuration configuration, String key, String defaultVal, String type) {
        String hostName = configuration.get(key, defaultVal);
        LOG.debug("%s endpoint host %s.", type, hostName);
        return hostName;
    }

    private static void setChannelOptions(BigtableOptions.Builder builder, Configuration configuration) throws IOException {
        BigtableOptionsFactory.setCredentialOptions(builder, configuration);
        builder.setRetryOptions(BigtableOptionsFactory.createRetryOptions(configuration));
        int channelCount = configuration.getInt(BIGTABLE_DATA_CHANNEL_COUNT_KEY, BigtableOptions.BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT);
        builder.setDataChannelCount(channelCount);
        int channelTimeout = configuration.getInt(BIGTABLE_CHANNEL_TIMEOUT_MS_KEY, BigtableOptions.BIGTABLE_CHANNEL_TIMEOUT_MS_DEFAULT);
        Preconditions.checkArgument(channelTimeout == 0 || channelTimeout >= 60000, "google.bigtable.grpc.channel.timeout.ms has to be 0 (no timeout) or 1 minute+ (60000)");
        builder.setTimeoutMs(channelTimeout);
        builder.setUserAgent(BigtableConstants.USER_AGENT);
    }

    private static void setCredentialOptions(BigtableOptions.Builder builder, Configuration configuration) throws FileNotFoundException {
        if (configuration.getBoolean(BIGTABE_USE_SERVICE_ACCOUNTS_KEY, true)) {
            LOG.debug("Using service accounts", new Object[0]);
            if (configuration.get(BIGTABLE_SERVICE_ACCOUNT_JSON_KEYFILE_LOCATION_KEY) != null) {
                String keyfileLocation = configuration.get(BIGTABLE_SERVICE_ACCOUNT_JSON_KEYFILE_LOCATION_KEY);
                LOG.debug("Using json keyfile: %s", keyfileLocation);
                builder.setCredentialOptions(CredentialOptions.jsonCredentials(new FileInputStream(keyfileLocation)));
            } else if (configuration.get(BIGTABLE_SERVICE_ACCOUNT_EMAIL_KEY) != null) {
                String serviceAccount = configuration.get(BIGTABLE_SERVICE_ACCOUNT_EMAIL_KEY);
                LOG.debug("Service account %s specified.", serviceAccount);
                String keyfileLocation = configuration.get(BIGTABLE_SERVICE_ACCOUNT_P12_KEYFILE_LOCATION_KEY);
                Preconditions.checkState(!Strings.isNullOrEmpty(keyfileLocation), "Key file location must be specified when setting service account email");
                LOG.debug("Using p12 keyfile: %s", keyfileLocation);
                builder.setCredentialOptions(CredentialOptions.p12Credential(serviceAccount, keyfileLocation));
            } else {
                LOG.debug("Using default credentials.", new Object[0]);
                builder.setCredentialOptions(CredentialOptions.defaultCredentials());
            }
        } else if (configuration.getBoolean(BIGTABLE_NULL_CREDENTIAL_ENABLE_KEY, false)) {
            builder.setCredentialOptions(CredentialOptions.nullCredential());
            LOG.info("Enabling the use of null credentials. This should not be used in production.", new Object[0]);
        } else {
            throw new IllegalStateException("Either service account or null credentials must be enabled");
        }
    }

    private static RetryOptions createRetryOptions(Configuration configuration) {
        RetryOptions.Builder retryOptionsBuilder = new RetryOptions.Builder();
        boolean enableRetries = configuration.getBoolean(ENABLE_GRPC_RETRIES_KEY, RetryOptions.ENABLE_GRPC_RETRIES_DEFAULT);
        LOG.debug("gRPC retries enabled: %s", enableRetries);
        retryOptionsBuilder.setEnableRetries(enableRetries);
        boolean retryOnDeadlineExceeded = configuration.getBoolean(ENABLE_GRPC_RETRY_DEADLINEEXCEEDED_KEY, RetryOptions.ENABLE_GRPC_RETRY_DEADLINE_EXCEEDED_DEFAULT);
        LOG.debug("gRPC retry on deadline exceeded enabled: %s", retryOnDeadlineExceeded);
        retryOptionsBuilder.setRetryOnDeadlineExceeded(retryOnDeadlineExceeded);
        int maxElapsedBackoffMillis = configuration.getInt(MAX_ELAPSED_BACKOFF_MILLIS_KEY, RetryOptions.DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS);
        LOG.debug("gRPC retry maxElapsedBackoffMillis: %d", maxElapsedBackoffMillis);
        retryOptionsBuilder.setMaxElapsedBackoffMillis(maxElapsedBackoffMillis);
        int readPartialRowTimeoutMillis = configuration.getInt(READ_PARTIAL_ROW_TIMEOUT_MS, RetryOptions.DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS);
        LOG.debug("gRPC read partial row timeout (millis): %d", readPartialRowTimeoutMillis);
        retryOptionsBuilder.setReadPartialRowTimeoutMillis(readPartialRowTimeoutMillis);
        int streamingBufferSize = configuration.getInt(READ_BUFFER_SIZE, RetryOptions.DEFAULT_STREAMING_BUFFER_SIZE);
        LOG.debug("gRPC read buffer size (count): %d", streamingBufferSize);
        retryOptionsBuilder.setStreamingBufferSize(streamingBufferSize);
        int streamingBatchSize = configuration.getInt(READ_BATCH_SIZE, RetryOptions.DEFAULT_STREAMING_BATCH_SIZE);
        LOG.debug("gRPC read batch size (count): %d", streamingBatchSize);
        retryOptionsBuilder.setStreamingBatchSize(streamingBatchSize);
        return retryOptionsBuilder.build();
    }
}

