/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.cloud.bigtable.hbase.adapters.AppendAdapter;
import com.google.cloud.bigtable.hbase.adapters.BigtableResultScannerAdapter;
import com.google.cloud.bigtable.hbase.adapters.BigtableWhileMatchResultScannerAdapter;
import com.google.cloud.bigtable.hbase.adapters.DeleteAdapter;
import com.google.cloud.bigtable.hbase.adapters.GetAdapter;
import com.google.cloud.bigtable.hbase.adapters.IncrementAdapter;
import com.google.cloud.bigtable.hbase.adapters.MutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.PutAdapter;
import com.google.cloud.bigtable.hbase.adapters.RowAdapter;
import com.google.cloud.bigtable.hbase.adapters.ScanAdapter;
import com.google.cloud.bigtable.hbase.adapters.UnsupportedOperationAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;

public final class Adapters {
    public static final RowAdapter ROW_ADAPTER = new RowAdapter();
    public static final AppendAdapter APPEND_ADAPTER = new AppendAdapter();
    public static final IncrementAdapter INCREMENT_ADAPTER = new IncrementAdapter();
    public static final DeleteAdapter DELETE_ADAPTER = new DeleteAdapter();
    public static final FilterAdapter FILTER_ADAPTER = FilterAdapter.buildAdapter();
    public static final ScanAdapter SCAN_ADAPTER = new ScanAdapter(FILTER_ADAPTER);
    public static final BigtableResultScannerAdapter BIGTABLE_RESULT_SCAN_ADAPTER = new BigtableResultScannerAdapter(ROW_ADAPTER);
    public static final BigtableWhileMatchResultScannerAdapter BIGTABLE_WHILE_MATCH_RESULT_RESULT_SCAN_ADAPTER = new BigtableWhileMatchResultScannerAdapter(ROW_ADAPTER);
    public static final GetAdapter GET_ADAPTER = new GetAdapter(SCAN_ADAPTER);

    public static MutationAdapter createMutationsAdapter(PutAdapter putAdapter) {
        return new MutationAdapter(DELETE_ADAPTER, putAdapter, new UnsupportedOperationAdapter<Increment>("increment"), new UnsupportedOperationAdapter<Append>("append"));
    }

    public static PutAdapter createPutAdapter(Configuration config) {
        return new PutAdapter(config.getInt("hbase.client.keyvalue.maxsize", -1));
    }

    private Adapters() {
    }
}

