/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.admin.table.v1.ColumnFamily;
import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Splitter;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HColumnDescriptor;

public class ColumnDescriptorAdapter {
    public static final Set<String> SUPPORTED_OPTION_KEYS = ImmutableSet.of("MIN_VERSIONS", "TTL", "VERSIONS");
    public static final Set<String> IGNORED_OPTION_KEYS = ImmutableSet.of("COMPRESSION", "COMPRESSION_COMPACT", "DATA_BLOCK_ENCODING", "BLOCKCACHE", "CACHE_DATA_ON_WRITE", "CACHE_INDEX_ON_WRITE", new String[]{"CACHE_BLOOMS_ON_WRITE", "EVICT_BLOCKS_ON_CLOSE", "CACHE_DATA_IN_L1", "PREFETCH_BLOCKS_ON_OPEN", "BLOCKSIZE", "BLOOMFILTER", "REPLICATION_SCOPE", "IN_MEMORY"});
    public static final Map<String, String> SUPPORTED_OPTION_VALUES = ImmutableMap.of("KEEP_DELETED_CELLS", Boolean.toString(false), "COMPRESS_TAGS", Boolean.toString(false));
    static Splitter gcExpressionOrSplitter = Splitter.on("|").trimResults().omitEmptyStrings();
    static Splitter gcExpressionAndSplitter = Splitter.on("&").trimResults().omitEmptyStrings();

    public static List<String> getUnknownFeatures(HColumnDescriptor columnDescriptor) {
        ArrayList<String> unknownFeatures = new ArrayList<String>();
        for (Map.Entry entry : columnDescriptor.getConfiguration().entrySet()) {
            String key = (String)entry.getKey();
            if (SUPPORTED_OPTION_KEYS.contains(key) || IGNORED_OPTION_KEYS.contains(key) || SUPPORTED_OPTION_VALUES.containsKey(key)) continue;
            unknownFeatures.add(key);
        }
        return unknownFeatures;
    }

    public static Map<String, String> getUnsupportedFeatures(HColumnDescriptor columnDescriptor) {
        HashMap<String, String> unsupportedConfiguration = new HashMap<String, String>();
        Map configuration = columnDescriptor.getConfiguration();
        for (Map.Entry<String, String> entry : SUPPORTED_OPTION_VALUES.entrySet()) {
            if (!configuration.containsKey(entry.getKey()) || configuration.get(entry.getKey()) == null || entry.getValue().equals(configuration.get(entry.getKey()))) continue;
            unsupportedConfiguration.put(entry.getKey(), (String)configuration.get(entry.getKey()));
        }
        return unsupportedConfiguration;
    }

    public static void throwIfRequestingUnknownFeatures(HColumnDescriptor columnDescriptor) {
        List<String> unknownFeatures = ColumnDescriptorAdapter.getUnknownFeatures(columnDescriptor);
        if (!unknownFeatures.isEmpty()) {
            String featureString = String.format("Unknown configuration options: [%s]", Joiner.on(", ").join(unknownFeatures));
            throw new UnsupportedOperationException(featureString);
        }
    }

    public static void throwIfRequestingUnsupportedFeatures(HColumnDescriptor columnDescriptor) {
        Map<String, String> unsupportedConfiguration = ColumnDescriptorAdapter.getUnsupportedFeatures(columnDescriptor);
        if (!unsupportedConfiguration.isEmpty()) {
            ArrayList<String> configurationStrings = new ArrayList<String>(unsupportedConfiguration.size());
            for (Map.Entry<String, String> entry : unsupportedConfiguration.entrySet()) {
                configurationStrings.add(String.format("(%s: %s)", entry.getKey(), entry.getValue()));
            }
            String exceptionMessage = String.format("Unsupported configuration options: %s", Joiner.on(",").join(configurationStrings));
            throw new UnsupportedOperationException(exceptionMessage);
        }
    }

    public static String buildGarbageCollectionExpression(HColumnDescriptor columnDescriptor) {
        int maxVersions = columnDescriptor.getMaxVersions();
        int minVersions = columnDescriptor.getMinVersions();
        int ttlSeconds = columnDescriptor.getTimeToLive();
        long bigtableTtl = BigtableConstants.BIGTABLE_TIMEUNIT.convert(ttlSeconds, TimeUnit.SECONDS);
        Preconditions.checkState(minVersions < maxVersions, "HColumnDescriptor min versions must be less than max versions.");
        StringBuilder buffer = new StringBuilder();
        if (ttlSeconds != Integer.MAX_VALUE) {
            if (minVersions != 0) {
                buffer.append(String.format("(age() > %s && version() > %s)", bigtableTtl, minVersions));
            } else {
                buffer.append(String.format("(age() > %s)", bigtableTtl));
            }
        }
        if (buffer.length() != 0) {
            buffer.append(" || ");
        }
        buffer.append(String.format("(version() > %s)", maxVersions));
        return buffer.toString();
    }

    private static void convertGarbageCollectionExpression(String gcExpression, HColumnDescriptor columnDescriptor) {
        long bigtableTtl;
        int ttlSeconds;
        if (Strings.isNullOrEmpty(gcExpression)) {
            columnDescriptor.setMaxVersions(0);
            return;
        }
        String maxVersionExpression = null;
        String minVersionExpression = null;
        String ttlExpression = null;
        if (gcExpression.contains("||")) {
            for (String expression : gcExpressionOrSplitter.split(gcExpression)) {
                if (expression.contains("age()")) {
                    for (String expressionComponent : gcExpressionAndSplitter.split(expression)) {
                        if (expressionComponent.contains("age()") && expressionComponent.contains(">")) {
                            ttlExpression = expressionComponent.replaceAll("[()]", "");
                            continue;
                        }
                        if (expressionComponent.contains("version()") && expressionComponent.contains(">")) {
                            minVersionExpression = expressionComponent.replaceAll("[()]", "");
                            continue;
                        }
                        throw new IllegalStateException(String.format("Expression: '%s' could not be parsed.", expression));
                    }
                    continue;
                }
                if (expression.contains("version()") && expression.contains(">")) {
                    maxVersionExpression = expression.replaceAll("[()]", "");
                    continue;
                }
                throw new IllegalStateException(String.format("Expression: '%s' could not be parsed.", expression));
            }
        } else if (gcExpression.contains("version()") && gcExpression.contains(">")) {
            maxVersionExpression = gcExpression.replaceAll("[()]", "");
        } else {
            throw new IllegalStateException(String.format("Expression: '%s' could not be parsed.", maxVersionExpression));
        }
        int maxVersions = ColumnDescriptorAdapter.getInteger(maxVersionExpression);
        columnDescriptor.setMaxVersions(maxVersions);
        if (minVersionExpression != null) {
            int minVersions = ColumnDescriptorAdapter.getInteger(minVersionExpression);
            Preconditions.checkState(minVersions < maxVersions, "HColumnDescriptor min versions must be less than max versions.");
            columnDescriptor.setMinVersions(minVersions);
        }
        if (ttlExpression != null && (ttlSeconds = (int)TimeUnit.SECONDS.convert(bigtableTtl = ColumnDescriptorAdapter.getLong(ttlExpression).longValue(), BigtableConstants.BIGTABLE_TIMEUNIT)) != Integer.MAX_VALUE) {
            columnDescriptor.setTimeToLive(ttlSeconds);
        }
    }

    private static Integer getInteger(String expression) {
        return Integer.valueOf(ColumnDescriptorAdapter.getNumber(expression));
    }

    private static Long getLong(String expression) {
        return Long.valueOf(ColumnDescriptorAdapter.getNumber(expression));
    }

    public static String getNumber(String expression) {
        return expression.replaceFirst(".*> *(\\d+).*", "$1");
    }

    public ColumnFamily.Builder adapt(HColumnDescriptor columnDescriptor) {
        ColumnDescriptorAdapter.throwIfRequestingUnknownFeatures(columnDescriptor);
        ColumnDescriptorAdapter.throwIfRequestingUnsupportedFeatures(columnDescriptor);
        ColumnFamily.Builder resultBuilder = ColumnFamily.newBuilder();
        String gcExpression = ColumnDescriptorAdapter.buildGarbageCollectionExpression(columnDescriptor);
        if (!Strings.isNullOrEmpty(gcExpression)) {
            resultBuilder.setGcExpression(gcExpression);
        }
        return resultBuilder;
    }

    public HColumnDescriptor adapt(String familyName, ColumnFamily columnFamily) {
        HColumnDescriptor hColumnDescriptor = new HColumnDescriptor(familyName);
        ColumnDescriptorAdapter.convertGarbageCollectionExpression(columnFamily.getGcExpression(), hColumnDescriptor);
        return hColumnDescriptor;
    }
}

