/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import org.apache.hadoop.hbase.TableName;

public class ColumnFamilyFormatter {
    static final String COLUMN_FAMILIES_SEPARARATOR = "columnFamilies";
    private final BigtableTableName bigtableTableName;

    public static ColumnFamilyFormatter from(TableName tableName, BigtableOptions options) {
        return new ColumnFamilyFormatter(options.getClusterName().toTableName(tableName.getNameAsString()));
    }

    public ColumnFamilyFormatter(BigtableTableName bigtableTableName) {
        this.bigtableTableName = bigtableTableName;
    }

    public String formatForBigtable(String hbaseColumnFamily) {
        return String.format("%s/%s/%s", this.bigtableTableName.toString(), COLUMN_FAMILIES_SEPARARATOR, hbaseColumnFamily);
    }

    public String formatForHBase(String bigtableColumnFamily) {
        String tableName = this.bigtableTableName.toString();
        String familyPrefix = String.format("%s/%s", tableName, COLUMN_FAMILIES_SEPARARATOR);
        Preconditions.checkState(bigtableColumnFamily.startsWith(familyPrefix), "Column family '%s' needs to start with '%s'", bigtableColumnFamily, tableName);
        return bigtableColumnFamily.substring(familyPrefix.length());
    }
}

