/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.Mutation;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;

public class DeleteAdapter
implements OperationAdapter<Delete, MutateRowRequest.Builder> {
    static boolean isPointDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    static boolean isColumnDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    static boolean isFamilyDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    static boolean isFamilyVersionDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    static void throwOnUnsupportedCellType(Cell cell) {
        throw new UnsupportedOperationException(String.format("Cell type %s is unsupported.", cell.getTypeByte()));
    }

    static void throwOnUnsupportedDeleteFamilyVersion(Cell cell) {
        throw new UnsupportedOperationException("Cannot perform column family deletion at timestamp.");
    }

    static void throwIfUnsupportedDeleteFamily(Cell cell) {
        if (cell.getTimestamp() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot perform column family deletion before timestamp.");
        }
    }

    static void throwIfUnsupportedDeleteRow(Delete operation) {
        if (operation.getTimeStamp() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot perform row deletion at timestamp.");
        }
    }

    static void throwIfUnsupportedPointDelete(Cell cell) {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot delete single latest cell.");
        }
    }

    static Mutation.DeleteFromColumn.Builder addDeleteFromColumnMods(MutateRowRequest.Builder result, ByteString familyByteString, Cell cell) {
        Mutation.Builder modBuilder = result.addMutationsBuilder();
        Mutation.DeleteFromColumn.Builder deleteBuilder = modBuilder.getDeleteFromColumnBuilder();
        ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        deleteBuilder.setFamilyNameBytes(familyByteString);
        deleteBuilder.setColumnQualifier(cellQualifierByteString);
        long startTimestamp = BigtableConstants.BIGTABLE_TIMEUNIT.convert(cell.getTimestamp(), BigtableConstants.HBASE_TIMEUNIT);
        long endTimestamp = BigtableConstants.BIGTABLE_TIMEUNIT.convert(cell.getTimestamp() + 1L, BigtableConstants.HBASE_TIMEUNIT);
        if (DeleteAdapter.isPointDelete(cell)) {
            deleteBuilder.getTimeRangeBuilder().setStartTimestampMicros(startTimestamp);
            deleteBuilder.getTimeRangeBuilder().setEndTimestampMicros(endTimestamp);
        } else if (cell.getTimestamp() != Long.MAX_VALUE) {
            deleteBuilder.getTimeRangeBuilder().setEndTimestampMicros(endTimestamp);
        }
        return deleteBuilder;
    }

    static Mutation.DeleteFromFamily.Builder addDeleteFromFamilyMods(MutateRowRequest.Builder result, ByteString familyByteString) {
        Mutation.Builder modBuilder = result.addMutationsBuilder();
        Mutation.DeleteFromFamily.Builder deleteBuilder = modBuilder.getDeleteFromFamilyBuilder();
        deleteBuilder.setFamilyNameBytes(familyByteString);
        return deleteBuilder;
    }

    @Override
    public MutateRowRequest.Builder adapt(Delete operation) {
        MutateRowRequest.Builder result = MutateRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom(operation.getRow()));
        if (operation.getFamilyCellMap().isEmpty()) {
            DeleteAdapter.throwIfUnsupportedDeleteRow(operation);
            result.addMutationsBuilder().setDeleteFromRow(Mutation.DeleteFromRow.getDefaultInstance());
        } else {
            for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
                ByteString familyByteString = ByteString.copyFrom((byte[])entry.getKey());
                for (Cell cell : (List)entry.getValue()) {
                    if (DeleteAdapter.isColumnDelete(cell) || DeleteAdapter.isPointDelete(cell)) {
                        if (DeleteAdapter.isPointDelete(cell)) {
                            DeleteAdapter.throwIfUnsupportedPointDelete(cell);
                        }
                        DeleteAdapter.addDeleteFromColumnMods(result, familyByteString, cell);
                        continue;
                    }
                    if (DeleteAdapter.isFamilyDelete(cell)) {
                        DeleteAdapter.throwIfUnsupportedDeleteFamily(cell);
                        DeleteAdapter.addDeleteFromFamilyMods(result, familyByteString);
                        continue;
                    }
                    if (DeleteAdapter.isFamilyVersionDelete(cell)) {
                        DeleteAdapter.throwOnUnsupportedDeleteFamilyVersion(cell);
                        continue;
                    }
                    DeleteAdapter.throwOnUnsupportedCellType(cell);
                }
            }
        }
        return result;
    }
}

