/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.ReadModifyWriteRowRequest;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.DefaultReadHooks;
import com.google.cloud.bigtable.hbase.adapters.MutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.PutAdapter;
import com.google.cloud.bigtable.hbase.adapters.ReadHooks;
import com.google.cloud.bigtable.hbase.adapters.RowMutationsAdapter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;

public class HBaseRequestAdapter {
    protected final TableName tableName;
    protected final BigtableTableName bigtableTableName;
    protected final PutAdapter putAdapter;
    protected final MutationAdapter mutationAdapter;
    protected final RowMutationsAdapter rowMutationsAdapter;

    public HBaseRequestAdapter(BigtableClusterName clusterName, TableName tableName, Configuration config) {
        this.tableName = tableName;
        this.bigtableTableName = clusterName.toTableName(tableName.getQualifierAsString());
        this.putAdapter = Adapters.createPutAdapter(config);
        this.mutationAdapter = Adapters.createMutationsAdapter(this.putAdapter);
        this.rowMutationsAdapter = new RowMutationsAdapter(this.mutationAdapter);
    }

    public MutateRowRequest adapt(Delete delete) {
        MutateRowRequest.Builder requestBuilder = Adapters.DELETE_ADAPTER.adapt(delete);
        requestBuilder.setTableName(this.bigtableTableName.toString());
        return requestBuilder.build();
    }

    public ReadRowsRequest adapt(Get get) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        ReadRowsRequest.Builder builder = Adapters.GET_ADAPTER.adapt(get, (ReadHooks)readHooks);
        builder.setTableName(this.bigtableTableName.toString());
        return readHooks.applyPreSendHook(builder.build());
    }

    public ReadRowsRequest adapt(Scan scan) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        ReadRowsRequest.Builder builder = Adapters.SCAN_ADAPTER.adapt(scan, (ReadHooks)readHooks);
        builder.setTableName(this.bigtableTableName.toString());
        return readHooks.applyPreSendHook(builder.build());
    }

    public ReadModifyWriteRowRequest adapt(Append append) {
        ReadModifyWriteRowRequest.Builder builder = Adapters.APPEND_ADAPTER.adapt(append);
        builder.setTableName(this.bigtableTableName.toString());
        return builder.build();
    }

    public ReadModifyWriteRowRequest adapt(Increment increment) {
        ReadModifyWriteRowRequest.Builder builder = Adapters.INCREMENT_ADAPTER.adapt(increment);
        builder.setTableName(this.bigtableTableName.toString());
        return builder.build();
    }

    public MutateRowRequest adapt(Put put) {
        MutateRowRequest.Builder builder = this.putAdapter.adapt(put);
        builder.setTableName(this.bigtableTableName.toString());
        return builder.build();
    }

    public MutateRowRequest adapt(RowMutations mutations) {
        MutateRowRequest.Builder builder = this.rowMutationsAdapter.adapt(mutations);
        builder.setTableName(this.bigtableTableName.toString());
        return builder.build();
    }

    public MutateRowRequest adapt(Mutation mutation) {
        MutateRowRequest.Builder builder = this.mutationAdapter.adapt(mutation);
        builder.setTableName(this.bigtableTableName.toString());
        return builder.build();
    }

    public BigtableTableName getBigtableTableName() {
        return this.bigtableTableName;
    }

    public TableName getTableName() {
        return this.tableName;
    }
}

