/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.Mutation;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;

public class PutAdapter
implements OperationAdapter<Put, MutateRowRequest.Builder> {
    private final int maxKeyValueSize;

    public PutAdapter(int maxKeyValueSize) {
        this.maxKeyValueSize = maxKeyValueSize;
    }

    @Override
    public MutateRowRequest.Builder adapt(Put operation) {
        MutateRowRequest.Builder result = MutateRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom(operation.getRow()));
        if (operation.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            ByteString familyString = ByteString.copyFrom((byte[])entry.getKey());
            for (Cell cell : (List)entry.getValue()) {
                int keyValueSize = 20 + cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + cell.getValueLength();
                if (this.maxKeyValueSize > 0 && keyValueSize > this.maxKeyValueSize) {
                    throw new IllegalArgumentException("KeyValue size too large");
                }
                Mutation.Builder modBuilder = result.addMutationsBuilder();
                Mutation.SetCell.Builder setCellBuilder = modBuilder.getSetCellBuilder();
                ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                setCellBuilder.setFamilyNameBytes(familyString);
                setCellBuilder.setColumnQualifier(cellQualifierByteString);
                if (cell.getTimestamp() != Long.MAX_VALUE) {
                    long timestampMicros = BigtableConstants.BIGTABLE_TIMEUNIT.convert(cell.getTimestamp(), BigtableConstants.HBASE_TIMEUNIT);
                    setCellBuilder.setTimestampMicros(timestampMicros);
                } else {
                    setCellBuilder.setTimestampMicros(-1L);
                }
                setCellBuilder.setValue(ByteString.copyFrom(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
            }
        }
        return result;
    }
}

