/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RowMutations;

public class RowMutationsAdapter {
    protected final OperationAdapter<Mutation, MutateRowRequest.Builder> mutationAdapter;

    public RowMutationsAdapter(OperationAdapter<Mutation, MutateRowRequest.Builder> mutationAdapter) {
        this.mutationAdapter = mutationAdapter;
    }

    public MutateRowRequest.Builder adapt(RowMutations mutations) {
        MutateRowRequest.Builder result = MutateRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom(mutations.getRow()));
        for (Mutation mutation : mutations.getMutations()) {
            MutateRowRequest.Builder bigtableBuilder = this.mutationAdapter.adapt(mutation);
            result.addAllMutations(bigtableBuilder.getMutationsList());
        }
        return result;
    }
}

