/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.admin.table.v1.ColumnFamily;
import com.google.bigtable.admin.table.v1.Table;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.hbase.adapters.ColumnDescriptorAdapter;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;

public class TableAdapter {
    private final BigtableClusterName bigtableClusterName;
    private final ColumnDescriptorAdapter columnDescriptorAdapter;

    public TableAdapter(BigtableOptions options, ColumnDescriptorAdapter columnDescriptorAdapter) {
        this.bigtableClusterName = options.getClusterName();
        this.columnDescriptorAdapter = columnDescriptorAdapter;
    }

    public Table adapt(HTableDescriptor desc) {
        Table.Builder tableBuilder = Table.newBuilder();
        Map<String, ColumnFamily> columnFamilies = tableBuilder.getMutableColumnFamilies();
        for (HColumnDescriptor column : desc.getColumnFamilies()) {
            ColumnFamily columnFamily = this.columnDescriptorAdapter.adapt(column).build();
            String columnName = column.getNameAsString();
            columnFamilies.put(columnName, columnFamily);
        }
        return tableBuilder.build();
    }

    public HTableDescriptor adapt(Table table) {
        String tableId = this.bigtableClusterName.toTableId(table.getName());
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableId));
        for (Map.Entry<String, ColumnFamily> entry : table.getColumnFamilies().entrySet()) {
            tableDescriptor.addFamily(this.columnDescriptorAdapter.adapt(entry.getKey(), entry.getValue()));
        }
        return tableDescriptor;
    }
}

