/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;

public class ColumnPrefixFilterAdapter
implements TypedFilterAdapter<ColumnPrefixFilter> {
    ReaderExpressionHelper readerExpressionHelper = new ReaderExpressionHelper();

    @Override
    public RowFilter adapt(FilterAdapterContext context, ColumnPrefixFilter filter) throws IOException {
        byte[] prefix = filter.getPrefix();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(prefix.length * 2);
        ReaderExpressionHelper.writeQuotedRegularExpression(outputStream, prefix);
        outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        return RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFrom(outputStream.toByteArray())).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

