/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.v1.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.UnsupportedStatusCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;

public class FilterListAdapter
implements TypedFilterAdapter<FilterList>,
UnsupportedStatusCollector<FilterList> {
    private final FilterAdapter subFilterAdapter;

    public FilterListAdapter(FilterAdapter subFilterAdapter) {
        this.subFilterAdapter = subFilterAdapter;
    }

    @Override
    public RowFilter adapt(FilterAdapterContext context, FilterList filter) throws IOException {
        try (FilterAdapterContext.ContextCloseable ignored = context.beginFilterList(filter);){
            List<RowFilter> childFilters = this.collectChildFilters(context, filter);
            if (childFilters.isEmpty()) {
                RowFilter rowFilter = null;
                return rowFilter;
            }
            if (childFilters.size() == 1) {
                RowFilter rowFilter = childFilters.get(0);
                return rowFilter;
            }
            if (filter.getOperator() == FilterList.Operator.MUST_PASS_ALL) {
                RowFilter rowFilter = RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addAllFilters(childFilters)).build();
                return rowFilter;
            }
            RowFilter rowFilter = RowFilter.newBuilder().setInterleave(RowFilter.Interleave.newBuilder().addAllFilters(childFilters)).build();
            return rowFilter;
        }
    }

    List<RowFilter> collectChildFilters(FilterAdapterContext context, FilterList filter) throws IOException {
        ArrayList<RowFilter> result = new ArrayList<RowFilter>();
        for (Filter subFilter : filter.getFilters()) {
            Optional<RowFilter> potentialFilter = this.subFilterAdapter.adaptFilter(context, subFilter);
            if (!potentialFilter.isPresent()) continue;
            result.add(potentialFilter.get());
        }
        return result;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FilterList filter) {
        ArrayList<FilterSupportStatus> unsupportedSubfilters = new ArrayList<FilterSupportStatus>();
        try (FilterAdapterContext.ContextCloseable ignored = context.beginFilterList(filter);){
            this.collectUnsupportedStatuses(context, filter, (List<FilterSupportStatus>)unsupportedSubfilters);
        }
        if (unsupportedSubfilters.isEmpty()) {
            return FilterSupportStatus.SUPPORTED;
        }
        return FilterSupportStatus.newCompositeNotSupported(unsupportedSubfilters);
    }

    @Override
    public void collectUnsupportedStatuses(FilterAdapterContext context, FilterList filter, List<FilterSupportStatus> unsupportedStatuses) {
        for (Filter subFilter : filter.getFilters()) {
            this.subFilterAdapter.collectUnsupportedStatuses(context, subFilter, unsupportedStatuses);
        }
    }
}

