/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import com.google.cloud.bigtable.util.ByteStringer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Pair;

public class FuzzyRowFilterAdapter
implements TypedFilterAdapter<FuzzyRowFilter> {
    private static final RowFilter ALL_VALUES_FILTER = RowFilter.newBuilder().setCellsPerColumnLimitFilter(Integer.MAX_VALUE).build();

    @Override
    public RowFilter adapt(FilterAdapterContext context, FuzzyRowFilter filter) throws IOException {
        RowFilter.Interleave.Builder interleaveBuilder = RowFilter.Interleave.newBuilder();
        List<Pair<byte[], byte[]>> pairs = FuzzyRowFilterAdapter.extractFuzzyRowFilterPairs(filter);
        if (pairs.isEmpty()) {
            return ALL_VALUES_FILTER;
        }
        for (Pair<byte[], byte[]> pair : pairs) {
            Preconditions.checkArgument(((byte[])pair.getFirst()).length == ((byte[])pair.getSecond()).length, "Fuzzy info and match mask must have the same length");
            interleaveBuilder.addFilters(FuzzyRowFilterAdapter.createSingleRowFilter((byte[])pair.getFirst(), (byte[])pair.getSecond()));
        }
        return RowFilter.newBuilder().setInterleave(interleaveBuilder).build();
    }

    private static RowFilter createSingleRowFilter(byte[] first, byte[] second) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(first.length * 2);
        ReaderExpressionHelper.QuoteMetaOutputStream quotingStream = new ReaderExpressionHelper.QuoteMetaOutputStream(baos);
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == 0) {
                quotingStream.write(second[i]);
                continue;
            }
            baos.write(ReaderExpressionHelper.ANY_BYTE_BYTES);
        }
        ByteString quotedValue = ByteStringer.wrap(baos.toByteArray());
        quotingStream.close();
        return RowFilter.newBuilder().setRowKeyRegexFilter(quotedValue).build();
    }

    private static List<Pair<byte[], byte[]>> extractFuzzyRowFilterPairs(FuzzyRowFilter filter) throws IOException {
        FilterProtos.FuzzyRowFilter filterProto = FilterProtos.FuzzyRowFilter.parseFrom((byte[])filter.toByteArray());
        ArrayList<Pair<byte[], byte[]>> result = new ArrayList<Pair<byte[], byte[]>>(filterProto.getFuzzyKeysDataCount());
        for (HBaseProtos.BytesBytesPair protoPair : filterProto.getFuzzyKeysDataList()) {
            result.add((Pair<byte[], byte[]>)new Pair((Object)protoPair.getFirst().toByteArray(), (Object)protoPair.getSecond().toByteArray()));
        }
        return result;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FuzzyRowFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

