/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v1.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import com.google.cloud.bigtable.util.ByteStringer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;

public class MultipleColumnPrefixFilterAdapter
implements TypedFilterAdapter<MultipleColumnPrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, MultipleColumnPrefixFilter filter) throws IOException {
        RowFilter.Interleave.Builder interleaveBuilder = RowFilter.Interleave.newBuilder();
        ByteArrayOutputStream outputStream = null;
        for (byte[] prefix : filter.getPrefix()) {
            if (outputStream == null) {
                outputStream = new ByteArrayOutputStream(prefix.length * 2);
            }
            outputStream.reset();
            ReaderExpressionHelper.writeQuotedExpression(outputStream, prefix);
            outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
            RowFilter.Builder singlePrefixBuilder = RowFilter.newBuilder();
            singlePrefixBuilder.setColumnQualifierRegexFilter(ByteStringer.wrap(outputStream.toByteArray()));
            interleaveBuilder.addFilters(singlePrefixBuilder);
        }
        return RowFilter.newBuilder().setInterleave(interleaveBuilder).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, MultipleColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

