/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import com.google.cloud.bigtable.util.ByteStringer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.PrefixFilter;

public class PrefixFilterAdapter
implements TypedFilterAdapter<PrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, PrefixFilter filter) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(filter.getPrefix().length * 2);
        ReaderExpressionHelper.writeQuotedRegularExpression(baos, filter.getPrefix());
        baos.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        ByteString quotedValue = ByteStringer.wrap(baos.toByteArray());
        return RowFilter.newBuilder().setRowKeyRegexFilter(quotedValue).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, PrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

