/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v1.ColumnRange;
import com.google.bigtable.v1.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import com.google.cloud.bigtable.util.ByteStringer;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;

public class QualifierFilterAdapter
implements TypedFilterAdapter<QualifierFilter> {
    private static final FilterSupportStatus SINGLE_FAMILY_REQUIRED = FilterSupportStatus.newNotSupported("QualifierFilter must have a single column family specified in the Scan when not using CompareOp.EQUAL.");
    private static final FilterSupportStatus UNSUPPORTED_COMPARABLE = FilterSupportStatus.newNotSupported("QualifierFilter must have a BinaryComparator with any CompareOp or a RegexStringComparator with a EQUAL COmpareOp.");

    @Override
    public RowFilter adapt(FilterAdapterContext context, QualifierFilter filter) throws IOException {
        if (filter.getComparator() instanceof RegexStringComparator) {
            return this.adaptRegexStringComparator(filter.getOperator(), (RegexStringComparator)filter.getComparator());
        }
        if (filter.getComparator() instanceof BinaryComparator) {
            return this.adaptBinaryComparator(context, filter.getOperator(), (BinaryComparator)filter.getComparator());
        }
        throw new IllegalStateException(String.format("Cannot adapt comparator %s", filter.getComparator().getClass().getCanonicalName()));
    }

    private RowFilter adaptBinaryComparator(FilterAdapterContext context, CompareFilter.CompareOp compareOp, BinaryComparator comparator) throws IOException {
        byte[] quoted = ReaderExpressionHelper.quoteRegularExpression(comparator.getValue());
        ByteString quotedValue = ByteStringer.wrap(quoted);
        switch (compareOp) {
            case LESS: {
                return RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(FilterAdapterHelper.getSingleFamilyName(context)).setEndQualifierExclusive(quotedValue)).build();
            }
            case LESS_OR_EQUAL: {
                return RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(FilterAdapterHelper.getSingleFamilyName(context)).setEndQualifierInclusive(quotedValue)).build();
            }
            case EQUAL: {
                return RowFilter.newBuilder().setColumnQualifierRegexFilter(quotedValue).build();
            }
            case NOT_EQUAL: {
                String familyName = FilterAdapterHelper.getSingleFamilyName(context);
                return RowFilter.newBuilder().setInterleave(RowFilter.Interleave.newBuilder().addFilters(RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(familyName).setEndQualifierExclusive(quotedValue))).addFilters(RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(familyName).setStartQualifierExclusive(quotedValue)))).build();
            }
            case GREATER_OR_EQUAL: {
                return RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(FilterAdapterHelper.getSingleFamilyName(context)).setStartQualifierInclusive(quotedValue)).build();
            }
            case GREATER: {
                return RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(FilterAdapterHelper.getSingleFamilyName(context)).setStartQualifierExclusive(quotedValue)).build();
            }
            case NO_OP: {
                return FilterAdapterHelper.ACCEPT_ALL_FILTER;
            }
        }
        throw new IllegalStateException(String.format("Cannot handle unknown compare op %s", compareOp));
    }

    private RowFilter adaptRegexStringComparator(CompareFilter.CompareOp compareOp, RegexStringComparator comparator) {
        String pattern = FilterAdapterHelper.extractRegexPattern(comparator);
        switch (compareOp) {
            case EQUAL: {
                return RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFromUtf8(pattern)).build();
            }
            case NO_OP: {
                return FilterAdapterHelper.ACCEPT_ALL_FILTER;
            }
        }
        throw new IllegalStateException(String.format("Cannot adapt regex filter with compare op %s", compareOp));
    }

    private static boolean isRegexAndSupported(QualifierFilter filter) {
        return filter.getComparator() instanceof RegexStringComparator && CompareFilter.CompareOp.EQUAL.equals((Object)filter.getOperator());
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, QualifierFilter filter) {
        if (!CompareFilter.CompareOp.EQUAL.equals((Object)filter.getOperator()) && filter.getComparator() instanceof BinaryComparator && context.getScan().numFamilies() != 1) {
            return SINGLE_FAMILY_REQUIRED;
        }
        if (!(filter.getComparator() instanceof BinaryComparator) && !QualifierFilterAdapter.isRegexAndSupported(filter)) {
            return UNSUPPORTED_COMPARABLE;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

