/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.bigtable.repackaged.com.google.protobuf.BigtableZeroCopyByteStringUtil;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteStringer {
    private static final Log LOG = LogFactory.getLog(ByteStringer.class);
    private static boolean USE_ZEROCOPYBYTESTRING = true;

    private ByteStringer() {
    }

    public static ByteString wrap(byte[] array) {
        return USE_ZEROCOPYBYTESTRING ? BigtableZeroCopyByteStringUtil.wrap(array) : ByteString.copyFrom(array);
    }

    public static byte[] extract(ByteString buf) {
        return USE_ZEROCOPYBYTESTRING ? BigtableZeroCopyByteStringUtil.zeroCopyGetBytes(buf) : buf.toByteArray();
    }

    static {
        try {
            BigtableZeroCopyByteStringUtil.wrap(new byte[0]);
        }
        catch (IllegalAccessError iae) {
            USE_ZEROCOPYBYTESTRING = false;
            LOG.debug((Object)("Failed to classload BigtableZeroCopyByteString: " + iae.toString()));
        }
    }
}

